import { Component, OnInit } from '@angular/core';
import { ActivatedRoute,Router } from "@angular/router";
import { MyService } from '../../my.service';
import { LifeCommonService } from "../../../common/life-common.service";
import { environment } from '../../../../environments/environment';
@Component({
  selector: 'ydlife-invitation',
  templateUrl: './invitation.component.html',
  styleUrls: ['./invitation.component.scss']
})
export class InvitationComponent implements OnInit {
  //判断邀请人/被邀请人
  type: string;
  //邀请人名字
  invitatorName:string;
  lifeCustomerInfo: any;
  deviceType:any;
  hiringBasicInfoId:any;
  //被邀请人
  inviteeName:string;
  constructor(private myService: MyService,
    private activatedRoute: ActivatedRoute,
    public lifeCommonService: LifeCommonService,
    private router: Router) { }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.lifeCustomerInfo = JSON.parse(localStorage.getItem('lifeCustomerInfo')) ? JSON.parse(localStorage.getItem('lifeCustomerInfo')) : null;
    this.type = this.activatedRoute.snapshot.data[0]['type'];
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.invitatorName = this.activatedRoute.snapshot.queryParams.invitatorName?this.activatedRoute.snapshot.queryParams.invitatorName:null;
    this.inviteeName = this.activatedRoute.snapshot.queryParams.inviteeName?this.activatedRoute.snapshot.queryParams.inviteeName:null;
    this.deviceType = this.lifeCommonService.checkDeviceType();
    this.sandInvitation(2);
  }

  //分享邀请
  sandInvitation(type) {
    if(this.deviceType == 3){
      const imgUrl = this.lifeCustomerInfo.practitionerBasicInfo.headImagePath ? this.lifeCustomerInfo.practitionerBasicInfo.headImagePath : `${environment.DOMAINNAME}ydLife/assets/images/icons/meng.png`;
      this.lifeCommonService.wxShare(
        '银盾保险经纪电子报聘邀请函',
        `${this.lifeCustomerInfo.practitionerBasicInfo.name}邀请您报聘银盾保险经纪。加入靠谱的团队、一起做靠谱的事。`,
        `https://${window.location.host}/ydLife/invitees?hiringBasicInfoId=${this.hiringBasicInfoId}&invitatorName=${this.invitatorName}`,
        imgUrl);
        if(type==1){
          this.lifeCommonService.shareStatusPublish(1);
        }
      }else{
        alert('请在微信公众号中发送邀请');
      }
  }


  register(){
    this.router.navigate(['/register'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
  }
}
