import {Component, OnInit} from '@angular/core';
import {Router} from "@angular/router";
import {MyService} from "../my.service";

@Component({
  selector: 'ydlife-mk-material',
  templateUrl: './mk-material.component.html',
  styleUrls: ['./mk-material.component.scss']
})
export class MkMaterialComponent implements OnInit {
  posterInfos: Array<any>;

  constructor(private router: Router, private myService: MyService) {
  }

  ngOnInit() {
    this.posterQuery();
  }

  posterQuery() {
    this.myService.posterQuery({
      paginationInfo: {
        noLimitFlag: 'CONFIRM'
      }
    }).subscribe(res => {
      if (res['success']) {
        this.posterInfos = res['data']['posterInfos'];
      }
    });
  }

}
