import { Component, OnInit, Output, Input, EventEmitter } from '@angular/core';
import { MyService } from '../my.service';
import { ActivatedRoute } from "@angular/router";
import { BusinessQuery } from '../../domain/businessQuery';
import { LifeCommonService } from '../../common/life-common.service';
@Component({
  selector: 'ydlife-my-business-detail',
  templateUrl: './my-business-detail.component.html',
  styleUrls: ['./my-business-detail.component.scss']
})
export class MyBusinessDetailComponent implements OnInit {
  @Output() sendRemoveScrollContent = new EventEmitter();
  titleList: Array<any>;
  selectedId: number;
  surveyAnswersList: Array<any>;
  readonlyFlag: boolean = true;
  orderId: number;
  opportunityId: string;
  opportunitySurveyAnswersList: Array<any>;
  tagList: Array<any>;
  editBusiness: BusinessQuery = new BusinessQuery('1', null, null, null, null, null, null, null, null, null, null, null, null, null)
  businessStatusList: Array<any>;
  cityFlag: boolean;
  provinceList: Array<any>;
  provinces: Array<any>;
  constructor(private activateRoute: ActivatedRoute, private myService: MyService,
    public lifeCommonService: LifeCommonService) {
    this.titleList = [
      { id: 1, name: '基本信息' },
      { id: 2, name: '咨询服务' },
      { id: 3, name: '商机跟进' }
    ]
  }

  ngOnInit() {
    this.orderId = this.activateRoute.snapshot.queryParams['orderId'];
    this.opportunityId = this.activateRoute.snapshot.paramMap.get('id');
    this.selectTab(1);
    this.ownOpportunityDetailQuery();
    this.tagQuery();
    this.dropOptionsQuery();
    // 获取省份
    this.myService.provinceqry({ insurerId: 11 }).subscribe(res => {
      if (res['success']) {
        this.provinces = res['data'].provinceList;
      }
    })
  }

  editInfo() {
    this.readonlyFlag = false;
  }

  selectTab(id) {
    this.selectedId = id;
  }

  ownOpportunityDetailQuery() {
    // const detailParam = {
    //   opportunityId: this.opportunityId,
    //   orderId: this.orderId,
    //   practitionerId: JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']
    // }
    const detailParam = {
      opportunityId: 2,
      orderId: 8373,
      practitionerId: 1
    }
    this.myService.ownOpportunityDetailQuery(detailParam).subscribe((res) => {
      console.log(res)
      if (res['success']) {
        this.opportunitySurveyAnswersList = res['data']['opportunityConsultationInfo']['opportunitySurveyAnswersList']
        this.editBusiness = res['data']['opportunityBasicInformationInfo']
      } else {
        this.opportunitySurveyAnswersList = [];
      }
    })
  }

  saveInfo() {

  }

  tagQuery() {
    this.myService.tagQuery({ tagType: 2, isActive: 1 }).subscribe((res) => {
      if (res['success']) {
        this.tagList = res['data']['tagVOs'];
      }
    })
  }

  //选标签
  selectTag(tagItem) {
    tagItem.selected = !tagItem.selected;
    console.log(tagItem)
  }

  //选男女
  selectedGender(e) {
    this.editBusiness.gender = e;
  }
  //商机状态
  dropOptionsQuery() {
    this.myService.dropOptionsQuery({ code: 'bizchance_promotion_action' }).subscribe((res) => {
      console.log(res)
      if (res['success']) {
        this.businessStatusList = res['data']['dropMasterInfoList']['0']['dropOptionsInfoList'];
      }

    })
  }

  //   选择地址信息
  selectedArea() {
    this.sendRemoveScrollContent.emit(1);

    this.cityFlag = true;
  }

  //  获取地址信息
  getAreaInfo(e, type) {
    this.sendRemoveScrollContent.emit(0);
    this.cityFlag = false;


  }



}
