import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'secondsTransfer'
})
export class SecondsTransferPipe implements PipeTransform {
  
  transform(value: any, args?: any): any {
    const h = Math.floor(value / 3600) > 0 ? Math.floor(value / 3600) : '00';
    const m = Math.floor(value % 3600 / 60) > 0 ? Math.floor(value % 3600 / 60) : '00';
    const s = Math.floor(value % 60) > 0 ? Math.floor(value % 60) : '00';
    return h + ':' + m + ':' + s;
  }

}
