import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-training-records',
  templateUrl: './training-records.component.html',
  styleUrls: ['./training-records.component.scss']
})
export class TrainingRecordsComponent implements OnInit {
  public status:string;
  public customerId:string = localStorage.getItem('lifeCustomerInfo') ? JSON.parse(localStorage.getItem('lifeCustomerInfo')).customerId : null;
  public fileUploadItemList:Array<any>;





  filePathQuery(status){
    this.myService.filePath(3,0,23,'yd_trainning_file_type',null,this.customerId,status).subscribe(res=>{
      if(res['success']){
        this.fileUploadItemList = res['data']['fileUploadItemList']
      }
    })
  }
  constructor(private activatedRoute:ActivatedRoute,private myService:MyService) { }

  ngOnInit() {
    this.status = this.activatedRoute.snapshot.params['status'];
    this.filePathQuery(this.status)
  }

  

}
