import { Component, OnInit,ViewChild,ElementRef } from '@angular/core';
import { MyService } from '../my.service';
import { EChartOption } from 'echarts';
import { color } from 'html2canvas/dist/types/css/types/color';

const echarts = require('echarts');

@Component({
  selector: 'ydlife-my-management',
  templateUrl: './my-management.component.html',
  styleUrls: ['./my-management.component.scss']
})
export class MyManagementComponent implements OnInit {
  @ViewChild('echarts') echarts: ElementRef
  optList:Array<any>;
  mdDropOptionCode:string = null;
  year:number = (new Date()).getFullYear();
  month:number = (new Date()).getMonth() + 1;
  isTeam:number = 0;//0个人；1团队
  chartOption: EChartOption = {}
  personY:Array<any>;
  teamX:Array<any>;
  detailList:Array<any>;
  zeroList:Array<any>;
  fiftyList:Array<any>;
  seventyList:Array<any>;
  ninetyNineList:Array<any>;
  hundredList:Array<any>;
  my_chart;
  yearList:Array<any>;
  monthList:Array<any>;
  detailFlag:boolean = false;
  systemList:Array<any>;
  videoList:Array<any>;
  count:number;
  total:number;
  constructor(private myService: MyService) { }

  ngOnInit() {
    this.dropOptionsQuery('yd_trainning_file_type');
    this.changeIsTeam(0);
    this.yearList = [2018,2019,2020,2021,2022,2023,2024,2025];
    this.monthList = [1,2,3,4,5,6,7,8,9,10,11,12]
    this.my_chart = echarts.init(this.echarts.nativeElement);
    this.my_chart.on('click', (params) => {
      console.log(params)
  });

  }

  dropOptionsQuery(code){
    this.myService.dropOptionsQuery({code:code}).subscribe((res)=>{
      if(res['success']){
        this.optList = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'].filter((item)=>{
          return item.dropOptionCode != 'productTraining' && item.dropOptionCode!= 'trainingVideo'
        });
        this.optList = [{dropOptionCode:null,dropOptionName:'全部'}].concat(this.optList)
      }
      
    })
  }

  getCode(event){
    this.changeIsTeam(this.isTeam)
  }

  changeIsTeam(isTeam){
    this.isTeam = isTeam;
    const params = {
      dateSpan:`${this.year}-${this.month}-31 23:59:59`,
      // practitionerId:25,
      practitionerId:JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'],
      mdDropOptionCode:this.mdDropOptionCode
    }
    if(this.isTeam == 0){
      this.myService.personalCompletionRate(params).subscribe((res)=>{
        console.log(res)
        if(res['success']){
          this.zeroList = res['data']['zeroList'];
          this.fiftyList = res['data']['fiftyList'];
          this.seventyList = res['data']['seventyList'];
          this.ninetyNineList = res['data']['ninetyNineList'];
          this.hundredList = res['data']['hundredList'];
        }else{
          this.zeroList = this.fiftyList = this.seventyList = this.ninetyNineList =  this.hundredList = [];
        }
        this.detailList = this.zeroList.concat(this.fiftyList).concat(this.seventyList).concat(this.ninetyNineList).concat(this.hundredList)
        this.personY = [].concat(this.zeroList.length).concat(this.fiftyList.length).concat(this.seventyList.length).concat(this.ninetyNineList.length).concat(this.hundredList.length)
        this.chartOption = {
          xAxis: {
            type: 'category',
            name:'(学习进度)',
            nameTextStyle:{
              padding:[25,0,0,-28],
              color:'#666',
              fontSize:10
            },
            data: ['0', '1-50%', '51-70%', '71-99%', '100%'],
            axisLabel: { //坐标轴刻度标签的相关设置。
              interval: 0,//设置为 1,表示『隔一个标签显示一个标签』
              textStyle: {
                  fontSize: 10,
                  color:'#666'
              },
              rotate:0,
            },
            axisTick:{//坐标轴刻度相关设置。
                  show: false,
              },
              axisLine: {       // 坐标轴 轴线
                show: true,  // 是否显示
                //symbol: ['none', 'arrow'],  // 是否显示轴线箭头
                //symbolSize: [8, 8], // 箭头大小
                //symbolOffset: [0, 7],  // 箭头位置
                // ------   线 ---------
                lineStyle: {
                  color: '#5F83FF',
                  width: 2,
                  type: 'solid'
                }
              },
          },
          yAxis: {
            name:'(人)',
            show:true,
            type: 'value',
            splitNumber: 3,
            axisTick:{//坐标轴刻度相关设置。
                show: true,
              },
            axisLine:{
              show:true
            }
          },
          series: [
            {
              data: this.personY,
              type: 'bar',
              showBackground: false,
              barWidth: 30,
              itemStyle: {
                normal:{
                  show: true,
                  color: "#9EB4FF",
                  barBorderRadius:5,
                  borderWidth: 0,
                  label:{
                    formatter:"{c} 人",
                    show:true,
                    position:"top",
                    textStyle:{
                      fontWeight:"border",
                      fontSize:12,
                      color:"#333"
                    }
                  }
                }
              },
              emphasis: {
                itemStyle: {
                    color:'#5F83FF'
                }
              }
            }
          ]
        };
      })
      
    }
    if(this.isTeam == 1){
      this.myService.teamCompletionRate(params).subscribe((res)=>{
        console.log(res)
        if(res['success']){
          this.systemList = res['data']['systemList'];
        }else{
          this.systemList = [];
        }
        if(this.systemList.length){
          this.teamX = this.systemList.map((item)=>{
            return `${item.systemName}(${item.peopleRate})`
          });
          this.detailList = [];
          for(let i=0;i<this.systemList.length;i++){
            this.detailList = this.detailList.concat(this.systemList[i]['list'])
          }
        }
        this.chartOption = {
          xAxis: {
            type: 'category',
            data: this.teamX,
            name:'(团队/人)',
            nameTextStyle:{
              padding:[25,0,0,-28],
              color:'#666'
            },
            axisTick:{show: false},
            axisLabel: {
              show: true,
              interval:0,
              formatter:function(params) {
                  var newParamsName = "";
                  var paramsNameNumber = params.length;
                  var provideNumber = 5;  //一行显示几个字
                  var rowNumber = Math.ceil(paramsNameNumber / provideNumber);
                  if (paramsNameNumber > provideNumber) {
                      for (var p = 0; p < rowNumber; p++) {
                          var tempStr = "";
                          var start = p * provideNumber;
                          var end = start + provideNumber;
                          if (p == rowNumber - 1) {
                              tempStr = params.substring(start, paramsNameNumber);
                          } else {
                              tempStr = params.substring(start, end) + "\n";
                          }
                          newParamsName += tempStr;
                      }

                  } else {
                      newParamsName = params;
                  }
                  return newParamsName
              },
          }
          },
          yAxis: {
            type: 'value',
            name:'(学习进度%)',
            axisTick:{show: false},
            axisLabel:{
              textStyle: {
                fontSize: 10,
              },
              formatter:'{value}%'
            },
          },
          series: [
            {
              data: ['20', '40', '60','80', '100'],
              type: 'bar',
              showBackground: false,
              barWidth: 30,
              itemStyle: {
                normal:{
                  show: true,
                  color: "#9EB4FF",
                  barBorderRadius:5,
                  borderWidth: 0,
                  label:{
                    formatter:"{c} %",
                    show:true,
                    position:"top",
                    textStyle:{
                      fontWeight:"border",
                      fontSize:12,
                      color:"#333"
                    }
                  }
                },
              },
              emphasis: {
                itemStyle: {
                    color:'#5F83FF'
                }
              }
            }
          ]
        };
      })
    }
  }
 

  onChartClick(event){
    console.log(event.dataIndex)
    if(this.isTeam == 0){
      if(event.dataIndex == 0){
        this.detailList = this.zeroList;
      }else if(event.dataIndex == 1){
        this.detailList = this.fiftyList;
      }else if(event.dataIndex == 2){
        this.detailList = this.seventyList;
      }else if(event.dataIndex == 3){
        this.detailList = this.ninetyNineList;
      }else if(event.dataIndex == 4){
        this.detailList = this.hundredList;
      }
    }
    if(this.isTeam == 1){
      for(let i=0;i<this.systemList.length;i++){
        if(event.dataIndex == i){
          this.detailList = this.systemList[i]['list'];
        }
      }
    }
  }

  getLearnDetail(practitionerId){
    this.detailFlag = true;
    this.myService.queryLearningProgressDetail({practitionerId:practitionerId}).subscribe((res)=>{
      console.log(res)
      if(res['success']){
        this.videoList = res['data']['videoList'];
        this.count = res['data']['count'];
        this.total = res['data']['total'];
      }else{
        this.videoList = [];
        this.count = 0;
        this.total = 0;
      }
      
    })
  }
}
