import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Route, Router } from '@angular/router';
import { LifeCommonService } from 'src/app/common/life-common.service';
import { MyService } from '../my.service';

import { environment } from "../../../environments/environment";

@Component({
  selector: 'ydlife-menu-item',
  templateUrl: './menu-item.component.html',
  styleUrls: ['./menu-item.component.scss']
})
export class MenuItemComponent implements OnInit {
  type:string;
  menuLists:Array<any>;
  currentMenuLists:Array<any>;
  isShowSalay:boolean;
  lifeCustomerInfo: any;
  isNeedAlert: boolean;
  dialogInfo: any;
  //判断是否显示我的团队
  isShow: boolean;
  approvarList:Array<any>;
  dotFlag:boolean = false;
  constructor(private lifeCommonService:LifeCommonService,private activatedRoute:ActivatedRoute,private myService:MyService,private router:Router) {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.type = this.activatedRoute.snapshot.data[0]['type'];
    this.lifeCommonService.setTitle(title);
   }

  ngOnInit() {
    this.lifeCustomerInfo = JSON.parse(localStorage.getItem('lifeCustomerInfo')) ? JSON.parse(localStorage.getItem('lifeCustomerInfo')) : null;
    this.isShowSalay = this.lifeCustomerInfo.canSeeSalaryList==1?true:false;
    this.canSeeSalaryList();
    this.getMenuList();
    this.listQuery();
  }
  getMenuList() {
    this.menuLists = [
      {
        title: '营销工具',
        type:'marketing',
        content: [
          { no: 2, subtitle: 'AI保险医生', icon: 'ai', path: `https://${window.location.host}/questionnaire/#/index?campaign=AIRobot&task=AItask1&customerId=${this.lifeCustomerInfo.customerId}`, routerLink: '',showSubMenu:true },
          { no: 1, subtitle: '獴哥保险诊所', icon: 'clinic', path: `https://${window.location.host}/consulting`, routerLink: '' ,showSubMenu:true},
          { no: 4, subtitle: '线上投保', icon: 'online', path: `https://${window.location.host}/index?source=dyd`, routerLink: '' ,showSubMenu:true},
          { no: 13, subtitle: '我的商机', icon: 'line', path: '', routerLink: 'business',showSubMenu:true },
          { no: 7, subtitle: '文章分享', icon: 'article', path: '', routerLink: 'article/null' ,showSubMenu:true},
          { no: 3, subtitle: '产品海报', icon: 'poster_p', path: '/salesDetail', routerLink: 'material',showSubMenu:true },
          { no: 17, subtitle: '产品库', icon: 'product', path: '', routerLink: 'product' ,showSubMenu:true},
        ],
        isShow: true
      },
      {
        title: '我的团队',
        type:'team',
        content: [
          { no: 15, subtitle: '我的团队', icon: 'team', path: '', routerLink: '',showSubMenu:true },
          // { no: 16, subtitle: '团队增员', icon: 'recruiting', path: '', routerLink: '',showSubMenu:true },
          { no: 16, subtitle: '团队增员', icon: 'recruiting', path: '', routerLink: 'recruiting' ,showSubMenu:true},
          { no: 18, subtitle: '招募海报', icon: 'poster_r', path: '', routerLink: '',showSubMenu:true },
          { no: 22, subtitle: '报聘审批', icon: 'approval', path: '', routerLink: 'approval_list',dot: this.dotFlag,showSubMenu:true}
        ],
        // isShow: this.isShow
        isShow: true
      },
      {
        title: '我的展业',
        type:'exhibition',
        content: [
          { no: 23, subtitle: '新人入口', icon: 'pin', path: '', routerLink: 'newPeople' ,showSubMenu:true},
          { no: 24, subtitle: '目标设置', icon: 'set', path: '', routerLink: 'target',showSubMenu:true },
          { no: 21, subtitle: '公司制度', icon: 'management', path: '', routerLink: '',showSubMenu:true },
          { no: 33, subtitle: '佣金政策', icon: 'CommissionPolicy', path: '', routerLink: '',showSubMenu:true },
          { no: 12, subtitle: '销售保单', icon: 'policy', path: '', routerLink: '',showSubMenu:true },
          { no: 20, subtitle: '我的客户', icon: 'customer', path: '', routerLink: 'customer',showSubMenu:true },
          // { no: 14, subtitle: '我的佣金', icon: 'commission', path: '', routerLink: '',showSubMenu:true },
          { no: 19, subtitle: '薪资单', icon: 'salary', path: '', routerLink: 'salary',showSubMenu:this.isShowSalay },
          { no: 26, subtitle: '投核保知识库', icon: 'ask', path: '', routerLink: 'underwriting_knowledge' ,showSubMenu:true},
        ],
        isShow: true
      },
      {
        title: '教育培训',
        type:'trainingCenter',
        content: [
          { no: 5, subtitle: '保险ABC', icon: 'abc', path: `https://${window.location.host}/issue`, routerLink: '' ,showSubMenu:true},
          { no: 6, subtitle: '培训课件', icon: 'train', path: '', routerLink: 'training',showSubMenu:true },
          { no: 10, subtitle: '职业类别', icon: 'job', path: 'https://www.ydinsurance.cn/occupationQry/', routerLink: '',showSubMenu:true },
          { no: 11, subtitle: '文件下载', icon: 'download', path: 'https://www.ydinsurance.cn/?page_id=13957', routerLink: 'fileUpload',showSubMenu:true },
        ],
        isShow: true
      },{
        title:'新人入口',
        type:'newPeople',
        content:[
          { no: 28, subtitle: '欢迎信', icon: 'welcome', path: '', routerLink: 'thanks',showSubMenu:true },
          { no: 31, subtitle: '新人入职包', icon: 'NewcomerBag', path: '', routerLink: '',showSubMenu:true },
          { no: 30, subtitle: '执业证书', icon: 'card', path: `https://${window.location.host}/brokerQry/#/brokerDetail/${this.lifeCustomerInfo.practitionerId}?source=0`, routerLink: '',showSubMenu:true },
          { no: 32, subtitle: '公司介绍', icon: 'introduce', path: '', routerLink: '',showSubMenu:true },
          { no: 27, subtitle: '我的经纪合同', icon: 'contract', path: '', routerLink: 'my_application' ,showSubMenu:true},
          
        ]
      }
    ];
    this.currentMenuLists = this.menuLists.filter(item=>item.type == this.type)[0]['content'];
  }


  // 菜单导航
  menuNavigation(item) {
    if (item.routerLink) {
      this.router.navigate([`./${item.routerLink}`]);
    } else if (item.path) {
      window.open(item.path);
    }
    //  else if (item.no === 9) {
    //   this.shareIdCard();
    // }
    else if (item.no === 12) {
      this.router.navigate(['/salesDetail'], { queryParams: { searchType: 1, showType: 'orderform' } });
    } else if (item.no === 14) {
      this.router.navigate(['/salesDetail'], { queryParams: { searchType: 1, showType: 'sales' } });
    } else if (item.no === 15) {
      this.router.navigate(['/teamPanel'])
      // this.router.navigate(['/team_area'])
    } else if (!item.subtitle) {
      return;
    } else if (item.no === 18) {
      this.router.navigate(['/material'], { queryParams: { recruit: 'recruit' } });
    }else if(item.no === 21){
      //公司制度
      this.router.navigate(['/fileUpload'], { queryParams: { fileUploadType: 'management' } });
    }else if(item.no === 32){
      //公司介绍
      this.router.navigate(['/fileUpload'], { queryParams: { fileUploadType: 'introduce' } });
    }else if(item.no === 31){
      //新人入职包
      this.router.navigate(['/fileUpload'], { queryParams: { fileUploadType: 'newRecruits' } });
    }else if(item.no === 33){
      //佣金政策
      this.router.navigate(['/fileUpload'], { queryParams: { fileUploadType: 'commissionPolicy' } });
    }else {
      this.isNeedAlert = true;
      this.dialogInfo = {
        title: null,
        content: { value: '即将开发，敬请期待！', align: 'center' },
        footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
      };
    }
  }


    //查询是否团队长
    subordinateSystemMemberQuery() {
      const practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
      this.myService.subordinateSystemMemberQuery({ practitionerId: practitionerId, time: 1 }).subscribe((res) => {
        if (res['success']) {
          this.isShow = true;
          sessionStorage.setItem('isTeamleader', '1');
          sessionStorage.setItem('subordinateSystemName', res['data']['subordinateSystemName']);
        } else {
          this.isShow = false;
          sessionStorage.setItem('isTeamleader', '0');
        }
      })
    }
    //判断是否显示薪资单
    canSeeSalaryList(){
      const practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
      this.myService.canSeeSalaryList(practitionerId).subscribe((res)=>{
        if(res['data'] && res['data'].canSeeSalaryList == 1){
          this.isShowSalay  = true;
          this.getMenuList();
        }else{
          this.isShowSalay  = false;
          this.getMenuList();
        }
      })
    }

      //  分享名片
  shareIdCard() {
    const imgUrl = this.lifeCustomerInfo.practitionerBasicInfo.headImagePath ? this.lifeCustomerInfo.practitionerBasicInfo.headImagePath : `${environment.ORIGINNAME}/ydLife/assets/images/icons/meng.png`;
    this.lifeCommonService.shareStatusPublish(1);
    this.lifeCommonService.wxShare(
      `银盾保险经纪 ${this.lifeCustomerInfo.practitionerBasicInfo.name}`,
      '您的家庭保险专家、财务策划师。规划成就人生。',
      `https://${window.location.host}/brokerQry/#/brokerDetail/${this.lifeCustomerInfo.practitionerId}`,
      imgUrl);
  }

    //查看判断待审批列表小圆点
    listQuery(){
      this.myService.listQuery({practitionerId:this.lifeCustomerInfo.practitionerId,approvingStatus:0}).subscribe((res)=>{
        if(res['success']){
          this.approvarList = res['data']['hiringListInfoList'];
          if(this.approvarList.length>0){
            this.dotFlag = true;
            this.getMenuList();
          }else{
            this.dotFlag = false;
          }
        }else{
          alert(res['message'])
        }
      })
    }

    getImgUrl(Img) {
      return 'assets/images/' + Img + '.png'
    }

}
