import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { environment } from '../../environments/environment';

@Injectable({
  providedIn: 'root'
})
export class MyService {
  constructor(private http: HttpClient) {
  }

  private API = environment.BACKEND_URL_CONFIG_VALUE;
  private ydapi = environment.ORIGINNAME;
  //  保存分享码
  shareCallBack(shareInfo) {
    const url = this.API + '/shareCallBack';
    return this.http
      .post(url, JSON.stringify(shareInfo));
  }

  //  文件下载
  filePath(itemType, itemId, fileCategory, code, mdDropOptionId) {
    const url = this.API + '/filePathQuery';
    return this.http
      .post(url, JSON.stringify({ itemType: itemType, itemId: itemId, fileCategory: fileCategory, code: code, mdDropOptionId: mdDropOptionId }));
  }

  //  重要公告
  announcementQuery(id, announcementTypeId) {
    const url = this.API + '/announcementQuery';
    return this.http
      .post(url, JSON.stringify({ id: id, announcementTypeId: announcementTypeId }));
  }

  //  产品海报
  posterQuery(paginationInfo) {
    const url = this.API + '/posterQuery';
    return this.http
      .post(url, JSON.stringify(paginationInfo));
  }

  //热销产品
  recommendPlanQuery(param) {
    const url = this.API + '/recommendPlanQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //培训资料分类
  dropOptionsQuery(param) {
    const url = this.API + "/metadata/dropOptionsQuery";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  queryproductlistbytag(param) {
    const url = this.API + "/queryproductlistbytag";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //经纪人商机列表
  ownOpportunityQuery(param) {
    const url = this.ydapi + "/practitioner/ownOpportunityQuery";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //经纪人商机详情
  ownOpportunityDetailQuery(param) {
    const url = this.ydapi + "/practitioner/ownOpportunityDetailQuery";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }
  //经纪人修改商机跟进信息
  ownOpportunityRecordSave(param) {
    const url = this.ydapi + "/practitioner/ownOpportunityRecordSave";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //标签列表查询
  tagQuery(param) {
    const url = this.API + "/metadata/tagQuery";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //商机基本信息保存
  ownOpportunityBasicInformationSave(param) {
    const url = this.ydapi + "/practitioner/ownOpportunityBasicInformationSave";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }
  //获取省份
  provinceqry(param) {
    const url = this.API + "/partner/provinceqry";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  /**
   * 获取城市
   * @param objParam
   * @returns {Promise<TResult2|TResult1>}
   */
  cityqry(param) {
    const url = this.API + '/partner/cityqry';
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //查保单明细
  practitionerPolicyListQuery(practitionerId) {
    const url = this.API + '/practitioner/practitionerPolicyListQuery';
    return this.http
      .post(url, JSON.stringify(practitionerId));
  }

  //查询团队业绩及是否团队长
  subordinateSystemMemberQuery(practitionerId) {
    const url = this.API + '/practitioner/subordinateSystemMemberQuery';
    return this.http
      .post(url, JSON.stringify(practitionerId));
  }

  //下载多媒体文件接口
  mediaGet(mediaId) {
    const url = this.ydapi + '/practitioner/mediaGet';
    return this.http.post(url, JSON.stringify(mediaId));
  }

  //设置查询
  mySettingQuery(practitionerId) {
    const url = this.ydapi + '/practitioner/settingQuery';
    return this.http.post(url, JSON.stringify(practitionerId));
  }

  //我的设置保存
  mySettingSave(param) {
    const url = this.ydapi + '/practitioner/settingSave';
    return this.http.post(url, JSON.stringify(param));
  }

  //删除生活照
  myImgDelete(param) {
    const url = this.ydapi + '/practitioner/imgDelete';
    return this.http.post(url, JSON.stringify(param));
  }


  //排行榜
  rank(param) {
    const url = this.ydapi + '/practitioner/rank';
    return this.http
      .post(url, JSON.stringify(param));
  }

}
