import { Component, OnInit,ViewChild,ElementRef  } from '@angular/core';
import { MyService } from '../../my.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";
import {SignaturePad} from 'angular2-signaturepad';
import EleSign from "elesigncode";
import * as $ from 'jquery';
@Component({
  selector: 'ydlife-signature',
  templateUrl: './signature.component.html',
  styleUrls: ['./signature.component.scss']
})
export class SignatureComponent implements OnInit {
  hiringBasicInfoId:any;
  signatureImage:string;
  signaturePadOptions:any;
  imgStr:any;
  @ViewChild(SignaturePad) signaturePad : SignaturePad;
  constructor(private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService) { 
      
    }

  ngOnInit() {
    this.signaturePadOptions = {
      minWidth: 2,
      maxWidth: 5,
      dotSize: 1.5,
      penColor: "#333",
      /* INVERSE BECAUSE IT IS SHOW ONLY IN LANDSCAPE */
      canvasWidth: 800,
      canvasHeight: 600,
      backgroundColor:"rgb(248 248 248)"
    }
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    var ele = document.getElementById("signature");
    var eleSign = new EleSign();//实例化对象
    eleSign.init({setBgColor:'#333333'}); //初始化
    eleSign.moutedEle(ele) //将签名节点放入到传入的element节点中
  }

  next(){
    this.saveDigitalSignatures();
    // this.router.navigate(['/employee_submit']);
  }

  drawComplete() {
    // will be notified of szimek/signature_pad's onEnd event
    console.log(this.signaturePad.toDataURL());
    this.imgStr = this.signaturePad.toDataURL();
  }

  drawStart() {
    // will be notified of szimek/signature_pad's onBegin event
    console.log('begin drawing');
  }

  saveDigitalSignatures(){
    const param = {
      hiringBasicInfoId:this.hiringBasicInfoId,
      imgStr:this.imgStr
    }
    this.myService.saveDigitalSignatures(param).subscribe((res)=>{
      console.log(res)
      if(res['success']){
        
      }
    })
  }
}
