import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-integration-rule',
  templateUrl: './integration-rule.component.html',
  styleUrls: ['./integration-rule.component.scss']
})
export class IntegrationRuleComponent implements OnInit {
  // 积分项目
  integralRuleInfos:Array<any>;
  // 积分兑换项目
  integralExchangeRuleInfos:Array<any>;

  constructor(private myService:MyService) { }

  ngOnInit() {
    this.queryIntegralRuleList()
  }
  queryIntegralRuleList(){
    this.myService.queryIntegralRuleList().subscribe(res=>{
      if(res['success']){
        if(res['data']['integralRuleInfos']){
          const result = res['data']['integralRuleInfos'];
          this.integralRuleInfos = result.filter(item=>item.integralType=='1');
          this.integralExchangeRuleInfos = result.filter(item=>item.integralType=='2')
        }
        
      }
    })
  }
}
