import { Component, OnInit } from '@angular/core';
import { MyService } from '../../my/my.service';
import { ActivatedRoute, Router } from "@angular/router";
import { LifeCommonService } from '../../common/life-common.service';

@Component({
  selector: 'ydlife-article-read',
  templateUrl: './article-read.component.html',
  styleUrls: ['./article-read.component.scss']
})
export class ArticleReadComponent implements OnInit {
  articleId:any;
  practitionerId:any;
  readerList:Array<any>;
  constructor( public activatedRoute: ActivatedRoute,
    private myService: MyService,
    public lifeCommonService: LifeCommonService,
    private router: Router) { }

  ngOnInit() {
    this.articleId = this.activatedRoute.snapshot.params['id'];
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.articleTrackQuery();
  }

  articleTrackQuery(){
    this.myService.articleTrackQuery(this.practitionerId,this.articleId).subscribe((res)=>{
      if(res['success']){
        this.readerList = res['data']['articleTrackQueryInfos'];
      }
    })
  }

  //获取默认头像
  getDefaultHead(headImagePath){
    if(!headImagePath){
      return 'assets/images/icons/meng.png';
    }else{
      return headImagePath;
    }
  }

  //判断性别
  getGender(sex){
    if(!sex){
      return '暂无'
    }else{
      return sex==1?'男':'女'
    }
  }
}
