import { Directive, ElementRef, HostListener } from '@angular/core';

@Directive({
  selector: '[ydlifeScroll]'
})
export class ScrollDirective {

  constructor(private el:ElementRef) { }

  @HostListener('touchmove') onTouchmove(){
    if(this.el.nativeElement.querySelector('#menuContainer')){
      if(parseInt(this.el.nativeElement.querySelector('#menuContainer').style.left, 0) < document.body.clientWidth / 2){
        this.el.nativeElement.querySelector('#menuContainer').style.transform = 'translateX(-50px)'
      }else{
        this.el.nativeElement.querySelector('#menuContainer').style.transform = 'translateX(50px)'
      }
    }
  }
  @HostListener('touchend') onTouchcancel(){
    setTimeout(()=>{
     if(this.el.nativeElement.querySelector('#menuContainer')){
      this.el.nativeElement.querySelector('#menuContainer').style.transform = 'translateX(0)'
     }
    },1000)
  }
}
