import { Component, OnInit, ViewChild, AfterViewInit, ElementRef ,Input} from '@angular/core';
import { Router } from "@angular/router";
@Component({
  selector: 'ydlife-thanks',
  templateUrl: './thanks.component.html',
  styleUrls: ['./thanks.component.scss']
})
export class ThanksComponent implements OnInit, AfterViewInit {
  @ViewChild('inkwell1') inkwell1: ElementRef
  @ViewChild('letter_src') letter_src: ElementRef
  @Input() isShowClose:boolean = true;
  vLetter: any;
  iSpeedInk: any;
  sText: any;
  iCurChar: any;
  sChars: any;
  iCurInk: any;
  sCurCaret: any;
  sCaret: any;
  brokerInfo: any;
  constructor(private router: Router) { }
  ngOnInit() {
    this.brokerInfo = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerBasicInfo']

  }
  ngAfterViewInit() {
    // this.vLetter = document.getElementById('letter');
    // this.iSpeedInk = 5;
    // this.sText = this.letter_src.nativeElement.innerHTML;
    // this.iCurChar = 0;
    // this.sChars = '<span>';
    // this.iCurInk = 0;
    // this.sCurCaret = '';
    // this.sCaret = "&nbsp;<img src='pen.gif' style='position:absolute' />";

    // this.doStep();
  }
  close() {
    this.router.navigate(['/my']);
  }

  doStep() {
    // current char
    var sChar = this.sText.charAt(this.iCurChar);
    // default char delay
    var iDelay = 32;
    if (sChar == '') {
      this.sCurCaret = '';
    } else if (sChar == '|') { // we use | symbol to emulate 'error' symbol
      sChar = '';
      this.sChars = this.sChars.substring(0, this.sChars.length - 1);
      iDelay = 64;
    } else if (sChar == '<') { // pass tags
      var iPos = this.sText.indexOf('>', this.iCurChar);
      sChar = this.sText.substring(this.iCurChar, iPos + 1);
      this.iCurChar = iPos;
    } else if (sChar == '&') { // pass html entities
      var iPos = this.sText.indexOf(';', this.iCurChar);
      sChar = this.sText.substring(this.iCurChar, iPos + 1);
      this.iCurChar = iPos;
    } else if (sChar == '.') { // custom delay in case of . symbol
      iDelay = 300;
    } else if (sChar == ',') { // custom delay in case of , symbol
      iDelay = 100;
    } else if (sChar == ' ') { // custom delay in case of space symbol
      iDelay = 32;
    } else if (this.iCurChar > 5) {
      this.sCurCaret = this.sCaret;
    }
    // expenditure of ink
    if (sChar == ' ') {
      this.iCurInk += this.iSpeedInk;
      sChar = '</span><span style="color:RGB(' + (this.iCurInk) + ',' + (this.iCurInk) + ',' + (this.iCurInk) + ')">' + sChar;
    }
    if (document.getElementById('inkwell2').style.visibility == 'visible') {
      this.sCurCaret = this.sCaret;
      document.getElementById('inkwell2').style.visibility = 'hidden';
      sChar = '</span><span style="color:RGB(0,0,0)">' + sChar;
    }
    // refresh Ink
    if (this.iCurInk > 160) {
      this.iCurInk = 0;
      document.getElementById('inkwell2').style.visibility = 'visible';
      iDelay = 1000;
      this.sCurCaret = '';
    }
    // add current char to chars
    this.sChars += sChar;
    // hide the caret at the end of the letter
    if (this.iCurChar == this.sText.length - 1)
      this.sCurCaret = '';
    // update letter with new chars
    this.vLetter.innerHTML = this.sChars + this.sCurCaret;
    // goto next char
    this.iCurChar++;
    // next step
    if (this.iCurChar < this.sText.length) {
      setTimeout(this.doStep, 20 + iDelay);
    }

    this.doStep();
  }



}
