import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { SettingInfo } from '../../domain/settinginfo';
import { Router } from "@angular/router";

@Component({
  selector: 'ydlife-my-setting',
  templateUrl: './my-setting.component.html',
  styleUrls: ['./my-setting.component.scss']
})

export class MySettingComponent implements OnInit {
  settingInfo: SettingInfo = new SettingInfo();

  constructor(
    private myService: MyService, private router: Router) { }

  ngOnInit() {
    this.mySettingQuery();
  }

  mySettingQuery() {
    const practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.myService.mySettingQuery({ practitionerId: practitionerId }).subscribe((res) => {
      if (res['success']) {
        this.settingInfo = res['data'];
      }
    })
  }

  getOut() {
    const objParam = {
      loginLogId: JSON.parse(localStorage.getItem('lifeCustomerInfo')).loginLogId,
      userId: JSON.parse(localStorage.getItem('lifeCustomerInfo')).customerId
    };
    this.myService.erpLogout(objParam).subscribe((res)=>{
      if(res['success']){
        localStorage.removeItem('lifeCustomerInfo');
        this.router.navigate(['/login']);
      }else{
        alert(res['message'])
      }
    })
  }

}
