import { Component, OnInit,ViewChild,ElementRef } from '@angular/core';
import { ActivatedRoute,Router } from "@angular/router";
import { MyService } from '../../my.service';
import { LifeCommonService } from "../../../common/life-common.service";

@Component({
  selector: 'ydlife-personal-statement',
  templateUrl: './personal-statement.component.html',
  styleUrls: ['./personal-statement.component.scss']
})
export class PersonalStatementComponent implements OnInit {
  @ViewChild('autofocusFlag') elementView: ElementRef;
  //判断是个人声明还是合同确认
  type:any;
  hiringBasicInfoId:any;
  dropOptionsInfoList:Array<any>;
  isNeedAlert: boolean;
  dialogInfo: any;
  autofocusFlag:boolean;
  dropOptionsInfoListParam:Array<any> = [];
  contractTermsList:Array<any>;
  everWork:string;
  constructor(private myService: MyService, 
    private activatedRoute: ActivatedRoute,
    public lifeCommonService: LifeCommonService,
    private router: Router) { }

  ngOnInit() {
    this.type = this.activatedRoute.snapshot.data[0]['type'];
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    if(this.type==="personal_statement"){
      this.dropOptionsQuery()
    }else{
      this.queryContractTerms()
    }
  }

  next(){
    if(this.type == 'personal_statement'){
      this.savePersonalStatements();
    }else if(this.type == 'contract'){
      this.router.navigate(['/signature'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
    }
  }

  dropOptionsQuery(){
    this.myService.dropOptionsQuery({code:'EHiring_Personal_Statements'}).subscribe((res)=>{
      if(res['success']){
        this.dropOptionsInfoList = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'];
        this.dropOptionsInfoList.forEach((item)=>{
          item.status = 0;
          item.userInput = null;
        })
      }else{
        this.openPopInfo(res['message'])
      }
    })
  }

   // 打开弹窗
   openPopInfo(message) {
    this.isNeedAlert = true;
    this.dialogInfo = {
      title: null,
      content: { value: message, align: 'center' },
      footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
    };
  }

  selectStatements(personalStatements){
    if( personalStatements.status ==1){
      personalStatements.status = 0;
    }else{
      personalStatements.status = 1;
    }
    if(personalStatements.id == '241' && personalStatements.status == 1){
      //点击曾经报聘输入报聘自动获取焦点
      this.elementView.nativeElement.focus();
    }
  }

  savePersonalStatements(){
    this.dropOptionsInfoListParam = [];
    for(let i=0;i<this.dropOptionsInfoList.length;i++){
      this.dropOptionsInfoList[i]['mdDropOptionName'] = this.dropOptionsInfoList[i]['dropOptionName'];
      this.dropOptionsInfoList[i]['mdDropOptionId'] = this.dropOptionsInfoList[i]['id'];
      if(this.dropOptionsInfoList[i]['id'] =='241'){
        this.dropOptionsInfoListParam.push({hiringBasicInfoId:this.hiringBasicInfoId,
          mdDropOptionName:this.dropOptionsInfoList[i]['dropOptionName'],
          mdDropOptionId:this.dropOptionsInfoList[i]['id'],
          status:this.dropOptionsInfoList[i]['status'],
          userInput:this.everWork?this.everWork:null
        })
      }else{
        this.dropOptionsInfoListParam.push({hiringBasicInfoId:this.hiringBasicInfoId,
          mdDropOptionName:this.dropOptionsInfoList[i]['dropOptionName'],
          mdDropOptionId:this.dropOptionsInfoList[i]['id'],
          status:this.dropOptionsInfoList[i]['status'],
          userInput:null
        })
      }
    }
    const param = {
      hiringBasicInfoId:this.hiringBasicInfoId,
      personalStatementList:this.dropOptionsInfoListParam
    }
    this.myService.savePersonalStatements(param).subscribe((res)=>{
      if(res['success']){
        this.router.navigate(['/contract'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
      }else{
        this.openPopInfo(res['message']);
      }
    })
  }
  
  queryContractTerms(){
    this.myService.queryContractTerms().subscribe((res)=>{
      console.log(res)
      if(res['success']){
        this.contractTermsList = res['data']['contractTermsList'];
      }
    })
  }

  // 关闭弹窗
  getPopInfo() {
    this.isNeedAlert = false;
  }

}
