import { Component, OnInit } from '@angular/core';
import { MyService } from '../../my.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";

@Component({
  selector: 'ydlife-bank-card',
  templateUrl: './bank-card.component.html',
  styleUrls: ['./bank-card.component.scss']
})
export class BankCardComponent implements OnInit {
   hiringBasicInfoId:any;
   bankAccountOpening:string;
   bankAccountId:string;
   toastDialog:boolean;
   toastInfo:any;
   sureBankAccountId:string;
  constructor(private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService) { }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    
  }

  next(){
      const param = {
        hiringBasicInfoId:this.hiringBasicInfoId,
        bankAccountOpening:this.bankAccountOpening,
        bankAccountId:this.bankAccountId
      }
      this.myService.saveBankAccount(param).subscribe((res)=>{
        if(res['success']){
          this.router.navigate(['/personal_statement'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
        }else{
          this.toastDialog = true;
          this.toastInfo = {
            status: 1,
            msg: res['message'],
            timeout: 3000,
            align: 'center'
          };
        }
      })
  }
}
