import { Component, OnInit } from '@angular/core';
import { Router,ActivatedRoute } from "@angular/router";
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-recruiting',
  templateUrl: './recruiting.component.html',
  styleUrls: ['./recruiting.component.scss']
})
export class RecruitingComponent implements OnInit {
  recruitingList: Array<any>;
  titleList: Array<any>;
  selectedId: any;
  pageType:any;
  showRecruitingList:Array<any>;
  selectedRecruiting:any;
  //控制弹框
  toastDialog: boolean;
  toastInfo: any;
  constructor(private router: Router, private myService: MyService,private activatedRoute: ActivatedRoute) {
    this.pageType = this.activatedRoute.snapshot.data[0]['type'];
   }

  ngOnInit() {
    //从日程进来的不显示tab
    if(this.pageType == 'recruiting'){
      this.titleList = [
        { id: 1, name: '待跟进' },
        { id: 2, name: '跟进中' },
        { id: 3, name: '已报聘' },
      ]
      this.selectTab(1);
    }else{
      this.recruitListQuery(null);
    } 
  }

  addMember() {
    this.router.navigate(['/recruiting/0']);
  }
  selectTab(id) {
    this.selectedId = id;
    this.recruitListQuery(id)
  }

  //1-待跟进，2-跟进中，3-已完成
  recruitListQuery(type) {
    const listParam = {
      status: type,
      practitionerId: JSON.parse(localStorage.getItem('lifeCustomerInfo')).practitionerId
    }
    this.myService.recruitListQuery(listParam).subscribe((res) => {
      if (res['success']) {
        this.recruitingList = res['data']['practitionerPotentialInfoList'];
        this.showRecruitingList = res['data']['practitionerPotentialInfoList'];
      }else{
        this.recruitingList = [];
        this.showRecruitingList = [];
      }
    })
  }

  change(event){
    this.showRecruitingList = this.recruitingList.filter((item)=>{
      if(item.name){
        return item.name.indexOf(event) !=-1;
      }
    })
  }

  isJumpToDetail(potentialId,recruitingItem?:any){
    if(this.pageType == 'recruiting'){
      this.router.navigate([`/recruiting/${potentialId}`], { queryParams: { status: this.selectedId} });
    }else{
      if(!this.selectedRecruiting){
        this.selectedRecruiting = recruitingItem; 
      }else{
        this.selectedRecruiting = undefined;
      }
      return;
    }
  }

  returnAddTask(){
    if(this.selectedRecruiting){
      const {potentialId}=this.selectedRecruiting;
      // this.router.navigate(['/addtask/'], { queryParams: { referPotentialId: potentialId },state:this.selectedRecruiting});
      this.router.navigate(['/addtask/'], { queryParams: { referPotentialId: potentialId }});
    }else{
      this.router.navigate(['/addtask/']);
    }
  }
}
