import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { LifeCommonService } from '../../common/life-common.service';
import { ActivatedRoute,Router } from "@angular/router";

@Component({
  selector: 'ydlife-salary',
  templateUrl: './salary.component.html',
  styleUrls: ['./salary.component.scss']
})
export class SalaryComponent implements OnInit {
  practitionerIdEG: any;
  practitionerId: any;
  payScaleInfos: Array<any>;
  //控制弹框
  toastDialog: boolean;
  toastInfo: any;
  tabList:Array<any>;
  selectedId:any = 1;
  constructor(private activatedRoute: ActivatedRoute,private myService: MyService,
     public lifeCommonService: LifeCommonService) { }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.practitionerIdEG = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerIdEG'];
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']
    this.payScaleListQuery();
    this.tabList = [
      {name:'2021年',id:1},
      {name:'历史薪资',id:2}
    ]
  }

  payScaleListQuery() {
    this.myService.payScaleListQuery({ practitionerIdEG: this.practitionerIdEG,practitionerId:this.practitionerId }).subscribe((res) => {
      if (res['success']) {
        this.payScaleInfos = res['data']['payScaleInfos'];
      } else {
        this.payScaleInfos = [];
      }
    })
  }

  //下载pdf
  getPdf(monShId,url) {
    if(url){
      window.open(url)
      // location.href = url;
    }else{
      this.myService.payScalePdf({ monShId: monShId, practitionerId: Number(this.practitionerId) }).subscribe((res) => {
        if (res['success']) {
          if (res['data']['url']) {
            window.open(res['data']['url'])
            // location.href = res['data']['url'];
          } else {
            this.toastDialog = true;
            this.toastInfo = {
              status: 1,
              msg: '暂无薪资单！',
              timeout: 3000,
              align: 'center'
            };
            return;
          }
        }
      })
    }
    
  }

  selectTab(tabId){
    this.selectedId = tabId;
  }
}
