import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { ActivatedRoute } from "@angular/router";

@Component({
  selector: 'ydlife-order-detail',
  templateUrl: './order-detail.component.html',
  styleUrls: ['./order-detail.component.scss']
})
export class OrderDetailComponent implements OnInit {
  orderNo: string;
  policyInfo: any;
  holderInfo: any;
  policyNo:string;
  insuredInfos: Array<any>;
  policyFactorInfos: Array<any>;
  relation_id:string;
  constructor(private myService: MyService, private activatedRoute: ActivatedRoute) { }

  ngOnInit() {
    this.orderNo = this.activatedRoute.snapshot.queryParams.orderNo;
    this.policyNo = this.activatedRoute.snapshot.queryParams.policyNo;
    this.relation_id = this.activatedRoute.snapshot.queryParams.relation_id;
    this.policyInfoQuery();
  }
  policyInfoQuery() {
    this.myService.policyInfoQuery({ orderNo: this.orderNo, platform: 2,policyNo:this.policyNo,relation_id:this.relation_id }).subscribe((res) => {
      if (res['success']) {
        this.policyInfo = res['data'];
        this.holderInfo = this.policyInfo['holderInfo'];
        this.insuredInfos = this.policyInfo['insuredInfos'];
        this.policyFactorInfos = this.policyInfo['policyFactorInfos'];
      }
    })
  }
}
