import { Component, OnInit } from '@angular/core';
import { LifeCommonService } from "../../common/life-common.service";
import { MyService } from "../my.service";
import { ActivatedRoute } from "@angular/router";

@Component({
  selector: 'ydlife-file-upload',
  templateUrl: './file-upload.component.html',
  styleUrls: ['./file-upload.component.scss']
})
export class FileUploadComponent implements OnInit {
  fileUploadItemList: Array<any>;
  // 判断是文件下载还是教育培训
  type: string;
  categoryList: Array<any>;
  selectedCategoryId: number;
  fileUploadType:any;
  constructor(private myService: MyService, private activatedRoute: ActivatedRoute) {
  }

  ngOnInit() {
    this.type = this.activatedRoute.snapshot.data[0]['type'];
    this.fileUploadType = this.activatedRoute.snapshot.queryParams.fileUploadType ? this.activatedRoute.snapshot.queryParams.fileUploadType : null;
    this.dropOptionsQuery();
    if (this.type === 'fileUpload') {
        this.fileUpload(3, 0, 19, 'yd_download_file_type', this.selectedCategoryId);
    } else if (this.type === 'training') {
      this.fileUpload(3, 0, 23, 'yd_trainning_file_type', this.selectedCategoryId);
    }

  }

  //  文件下载
  fileUpload(itemType, itemId, fileCategory, code, mdDropOptionId) {
    this.myService.filePath(itemType, itemId, fileCategory, code, mdDropOptionId).subscribe(res => {
      if (res['success']) {
        this.fileUploadItemList = res['data']['fileUploadItemList'];
      }
    });
  }

  //培训资料分类
  dropOptionsQuery() {
    const code = this.type === 'fileUpload' ? 'yd_download_file_type' : 'yd_trainning_file_type'
    this.myService.dropOptionsQuery({ code: code }).subscribe(res => {
      if (res['success']) {
        this.categoryList = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'];
        if (this.categoryList.length > 0) {
          if(this.fileUploadType){
            this.selectedCategoryId = 81;
          }else{
            this.selectedCategoryId = this.categoryList[0].id;
          }
          this.switchCategory(this.selectedCategoryId)
        }
      } else {
        this.categoryList = [];
      }
    })
  }

  switchCategory(e) {
    this.selectedCategoryId = e;
    if (this.type === 'fileUpload') {
      this.fileUpload(3, 0, 19, 'yd_download_file_type', this.selectedCategoryId);
    } else if (this.type === 'training') {
      this.fileUpload(3, 0, 23, 'yd_trainning_file_type', this.selectedCategoryId);
    }
  }
}
