import {Component, ElementRef, OnInit, ViewChild} from '@angular/core';
import jspdf from 'jspdf';
import html2canvas from 'html2canvas';

@Component({
  selector: 'ydlife-business-card',
  templateUrl: './business-card.component.html',
  styleUrls: ['./business-card.component.scss']
})
export class BusinessCardComponent implements OnInit {
  element:any;
  lifeCustomerInfo: any;
  canvasImg:any;
  showFlag:boolean = false;
  constructor() {
  }

  ngOnInit() {
    this.lifeCustomerInfo = JSON.parse(localStorage.getItem('lifeCustomerInfo'));
    setTimeout(()=>{
      this.getImg();
    },500)
   
  }

  getImg(){
    this.element = document.getElementById("brokerCardPositive");
    html2canvas(this.element).then(canvas => {
      // 修改生成的宽度
      canvas.style.width = "1000px";
      console.log(canvas, "生成的画布文件");
      
      this.canvasImg = canvas.toDataURL("image/png");
      if(canvas){
        this.showFlag = true;  
      }
    })
  }
  
  

  // downLoadJspdfs(){
  //   this.element = document.getElementById("brokerCardPositive");
  //   html2canvas(this.element,{ 
  //     logging:false     //一开始canvas设置不渲染页面
  //   }).then((canvas)=>{
  //     let pdf:any = new jspdf('p','mm','a4') //纵向，单位mm，A4纸张大小
  //     let ctx:any = canvas.getContext('2d'); //预设2维画布
  //     let a4w:number = 190;  //设置显示内容的大小，A4大小：210*297；最后显示在A4内部区域大小为：190*360
  //     let a4h:number = 200;
  //     let imgHeight:number = Math.floor(a4h*canvas.width/a4w); //按A4显示比例换算一页图像的像素高度
  //     let renderedHeight:number = 0;
      
  //     while(renderedHeight<canvas.height){//判断页面有内容时
  //       let page:any = document.createElement('canvas'); //创建画布
  //       page.width = canvas.width; //设置画布宽高等于内容宽高
  //       page.height = Math.min(imgHeight,canvas.height-renderedHeight); //画布的高等于内容的最小的高度（不足一页）
  //       //用getImageData裁剪指定区域，并绘制到前面创建的canvas对象中
  //       let a:any = page.getContext('2d');
  //       a.putImageData(ctx.getImageData(0,renderedHeight,canvas.width,Math.min(imgHeight,canvas.height-renderedHeight)),0,0);
  //       pdf.addImage(page.toDataURL('image/jpeg',1.0),'JPEG',10,10,a4w,Math.min(a4h,a4w*page.height/page.width)); //添加图片到页面，保留10mm边距

  //       renderedHeight += imgHeight;
  //       if(renderedHeight < canvas.height){
  //         pdf.addPage();
  //       }

  //     }
  //     pdf.save('content.pdf')
  //   });
  // }
  

}
