import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service'
import { ActivatedRoute,Router } from "@angular/router";
import { environment } from '../../../environments/environment';
import { LifeCommonService } from "../../common/life-common.service";

@Component({
  selector: 'ydlife-approval-result-list',
  templateUrl: './approval-result-list.component.html',
  styleUrls: ['./approval-result-list.component.scss']
})
export class ApprovalResultListComponent implements OnInit {
  approvalIdentity:any;
  hiringBasicInfoId:any;
  practitionerId:any;
  recordsList:Array<any>;
  //审批到哪一步
  hiringApproveStepsSeq:any;
  //控制弹框
  toastDialog: boolean;
  toastInfo: any;
  isShow:boolean = false;
  remark:string;
  constructor(private router:Router,public lifeCommonService:LifeCommonService,private myService:MyService,private activatedRoute: ActivatedRoute) { }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.approvalIdentity = this.activatedRoute.snapshot.queryParams.approvalIdentity?this.activatedRoute.snapshot.queryParams.approvalIdentity:null;
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.PractitionerHiringApproveRecords();
  }

  PractitionerHiringApproveRecords(){
    const param = {
      practitionerId:this.practitionerId,
      hiringBasicInfoId:this.hiringBasicInfoId
      
    }
    this.myService.detailQuery(param).subscribe((res)=>{
      if(res['success']){
        this.recordsList = res['data']['hiringApproveRecordsList'];
        this.hiringApproveStepsSeq = res['data']['hiringApproveStepsSeq'];
        sessionStorage.setItem('hiringApproveStepsSeq',this.hiringApproveStepsSeq)
      }else{
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: res['message'],
          timeout: 3000,
          align: 'center'
        };
      }
    })
  }
  
  jumpToDetail(){
    this.router.navigate([`/employee_basic_info`],{queryParams:{hiringBasicInfoId:this.hiringBasicInfoId,approvalIdentity:this.approvalIdentity}})
  }
  getDefaultHeadImg(str){
    if(!str){
      return `${environment.DOMAINNAME}/assets/img/meng.png`;
    }else{
      return str
    }
  } 
  
  goBack(){
    history.go(-1)
  }

  lookRemark(remark){
    this.isShow = true;
    this.remark = remark;
  }
}
