import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { LifeCommonService } from 'src/app/common/life-common.service';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-renewal-reminder-detail',
  templateUrl: './renewal-reminder-detail.component.html',
  styleUrls: ['./renewal-reminder-detail.component.scss']
})
export class RenewalReminderDetailComponent implements OnInit {
  practitionerId: number;
	orderPayId:  number;//续交记录id
	noticeType:  number;//1-短信 2-微信 3-电话
	content:  string; //通知内容
	remark:  string; //备注
  dialogDisabled:boolean;
  orderPayDetail:any;
  // 判断是经纪人1还是客户2看到的详情页面
  type:number = 1;
  isNeedAlert: boolean;
  dialogInfo: any;
  deviceType:number;
  sendContent:string;
  shareSelect(type){
    this.noticeType = type;
    this.dialogDisabled = true;
    if(this.noticeType===2){
      this.wxShare()
    }
  }
  close = (e)=>{
    this.dialogDisabled = false;
  }
  constructor(private myService:MyService,private route:ActivatedRoute,private lifeCommonService:LifeCommonService) { }

  ngOnInit() {
    this.deviceType = this.lifeCommonService.checkDeviceType();
    this.orderPayId = this.route.snapshot.params['orderPayId'];
    this.type = this.route.snapshot.data.type;
    this.practitionerId = localStorage.getItem('lifeCustomerInfo')?JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']:null;
    this.queryNoticeDetail();
  }

  queryNoticeDetail(){
    this.myService.queryNoticeDetail({orderPayId:this.orderPayId}).subscribe(res=>{
      if(res['success']){
        this.orderPayDetail = res['data']['orderPayDetail'];
        this.content = ` 尊敬的${this.orderPayDetail.policyholderName}您好，你在${this.orderPayDetail.insurerName}公司投保的${this.orderPayDetail.productName}产品，快到第${this.orderPayDetail.payPeriod}期续交保费了，当期保费${this.orderPayDetail.annualizedPremium}元，请在预留的银行卡准备好相应金额，避免保单失效和造成损失。谢谢！任何问题可以随时联络您的经纪人提供帮助。`
      }else{
        this.openPopInfo(res['message']);
      }
    })
  }

  addNotice(){
    this.myService.addNotice({practitionerId:this.practitionerId,orderPayId:this.orderPayId,noticeType:this.noticeType,content:this.content,remark:this.remark}).subscribe(res=>{
      this.openPopInfo(res['message']);
    })
  }

  wxShare(){
    this.lifeCommonService.wxShare('保单续期提醒','来自经纪人的温馨提醒，您有保单快到续期交费日期，点击看看以免忘记，避免损失。',`${window.location.origin}/ydLife/reminder_detail/${this.orderPayId}`,`${window.location.origin}/ydLife/assets/images/productData/protect.png`);
  }

  // 打开弹窗
  openPopInfo(message) {
    this.isNeedAlert = true;
    this.dialogInfo = {
      title: null,
      content: { value: message, align: 'center' },
      footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
    };
  }
  // 关闭弹窗
  getPopInfo() {
    this.isNeedAlert = false;
  }

}
