import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { environment } from '../../environments/environment';
import * as uuid from 'uuid';

@Injectable({
  providedIn: 'root'
})
export class MyService {
  constructor(private http: HttpClient) {
  }

  private API = environment.BACKEND_URL_CONFIG_VALUE;
  private ydapi = environment.ORIGINNAME;
  //  保存分享码
  shareCallBack(shareInfo) {
    const url = this.API + '/shareCallBack';
    return this.http
      .post(url, JSON.stringify(shareInfo));
  }

  //  文件下载
  filePath(itemType, itemId, fileCategory, code, mdDropOptionCode,customerId=null,learningStatus=null,fileId=null) {
    const url = this.API + '/filePathQuery';
    return this.http
      .post(url, JSON.stringify({ itemType: itemType, itemId: itemId, fileCategory: fileCategory, code: code, mdDropOptionCode: mdDropOptionCode,customerId:customerId,learningStatus:learningStatus,fileId:fileId }));
  }

  //  重要公告
  announcementQuery(id, announcementTypeId) {
    const url = this.ydapi + '/market/announcementQuery';
    return this.http
      .post(url, JSON.stringify({ id: id, announcementTypeId: announcementTypeId }));
  }

  //  产品海报
  posterQuery(paginationInfo) {
    const url = this.ydapi + '/market/posterQuery';
    return this.http
      .post(url, JSON.stringify(paginationInfo));
  }

  //热销产品
  recommendPlanQuery(param) {
    const url = this.API + '/recommendPlanQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //培训资料分类
  dropOptionsQuery(param) {
    const url = this.API + "/metadata/dropOptionsQuery";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  queryproductlistbytag(param) {
    const url = this.API + "/queryproductlistbytag";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //经纪人商机列表
  ownOpportunityQuery(param) {
    const url = this.ydapi + "/practitioner/ownOpportunityQuery";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //经纪人商机详情
  ownOpportunityDetailQuery(param) {
    const url = this.ydapi + "/practitioner/ownOpportunityDetailQuery";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }
  //经纪人修改商机跟进信息
  ownOpportunityRecordSave(param) {
    const url = this.ydapi + "/practitioner/ownOpportunityRecordSave";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //标签列表查询
  tagQuery(param) {
    const url = this.API + "/metadata/tagQuery";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //商机基本信息保存
  ownOpportunityBasicInformationSave(param) {
    const url = this.ydapi + "/practitioner/ownOpportunityBasicInformationSave";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }
  //获取省份
  provinceqry(param) {
    const url = this.API + "/partner/provinceqry";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  /**
   * 获取城市
   * @param objParam
   * @returns {Promise<TResult2|TResult1>}
   */
  cityqry(param) {
    const url = this.API + '/partner/cityqry';
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //查保单明细(不包括寿险)
  practitionerPolicyListQuery(practitionerId) {
    const url = this.API + '/practitioner/practitionerPolicyListQuery';
    return this.http
      .post(url, JSON.stringify(practitionerId));
  }

  //保单明细列表包括寿险
  policyListQuery(practitionerId) {
    const url = this.ydapi + '/practitioner/policyListQuery';
    return this.http
      .post(url, JSON.stringify(practitionerId));
  }

  //保单明细详细信息
  policyInfoQuery(practitionerId) {
    const url = this.ydapi + '/practitioner/policyInfoQuery';
    return this.http
      .post(url, JSON.stringify(practitionerId));
  }
  //查询团队业绩及是否团队长
  subordinateSystemMemberQuery(practitionerId) {
    const url = this.ydapi + '/practitioner/subordinateSystemMemberQuery';
    return this.http
      .post(url, JSON.stringify(practitionerId));
  }

  //下载多媒体文件接口
  mediaGet(mediaId) {
    const url = this.ydapi + '/practitioner/mediaGet';
    return this.http.post(url, JSON.stringify(mediaId));
  }

  //设置查询
  mySettingQuery(practitionerId) {
    const url = this.ydapi + '/practitioner/settingQuery';
    return this.http.post(url, JSON.stringify(practitionerId));
  }

  //我的设置保存
  mySettingSave(param) {
    const url = this.ydapi + '/practitioner/settingSave';
    return this.http.post(url, JSON.stringify(param));
  }

  //删除生活照
  myImgDelete(param) {
    const url = this.ydapi + '/practitioner/imgDelete';
    return this.http.post(url, JSON.stringify(param));
  }

  //排行榜
  rank(param) {
    const url = this.ydapi + '/practitioner/rank';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //新增增员接口
  recruit(param) {
    const url = this.ydapi + '/practitioner/recruit';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //创建增员跟进记录
  addRecruitTrack(param) {
    const url = this.ydapi + '/practitioner/addRecruitTrack';
    return this.http
      .post(url, JSON.stringify(param));
  }
  //增员查询跟进接口
  recruitTrackQuery(param) {
    const url = this.ydapi + '/practitioner/recruitTrackQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  // 教育等级查询
  educationLevelQuery() {
    const url = this.API + '/metadata/educationLevelQuery';
    return this.http.get(url);
  }

  //增员列表查询
  recruitListQuery(param) {
    const url = this.ydapi + '/practitioner/recruitListQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //过渡页心灵鸡汤
  knowledgeQry(param) {
    const url = this.API + '/metadata/knowledgeQry';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //经纪人商机分数统计
  opportunityStatistics(param) {
    const url = this.ydapi + '/practitioner/opportunityStatistics';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //销售目标保存
  salesTargetSave(param) {
    const url = this.ydapi + '/practitioner/salesTargetSave';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //查询销售目标
  salesTargetQuery(param) {
    const url = this.ydapi + '/practitioner/salesTargetQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //月均销售活动量
  salesTargetMonthSave(param) {
    const url = this.ydapi + '/practitioner/salesTargetMonthSave';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //增员目标保存
  potentialGoalsSetting(param) {
    const url = this.ydapi + '/practitioner/potentialGoalsSetting';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //增员目标查询接口
  potentialGoalsQuery(param) {
    const url = this.ydapi + '/practitioner/potentialGoalsQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //增员活动量更新
  potentialGoalsActionsUpdate(param) {
    const url = this.ydapi + '/practitioner/potentialGoalsActionsUpdate';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //活动量查询
  potentialGoalsActionsQuery(param) {
    const url = this.ydapi + '/practitioner/potentialGoalsActionsQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //团队平均
  teamActionsAverageQuery(param) {
    const url = this.ydapi + '/practitioner/teamActionsAverageQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //增员统计
  potentialActivityQuery(param) {
    const url = this.ydapi + '/practitioner/potentialActivityQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //团队成员销售活动量得分
  playerSalesActivityQuery(param) {
    const url = this.ydapi + '/practitioner/playerSalesActivityQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //团队成员销售业绩预测
  salesPerformanceForecastListQuery(param) {
    const url = this.ydapi + '/practitioner/salesPerformanceForecastListQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //销售活动量分值详情
  salesScoreDetailQuery(param) {
    const url = this.ydapi + '/practitioner/salesScoreDetailQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //薪资列表
  payScaleListQuery(param) {
    const url = this.ydapi + '/practitioner/payScaleListQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //薪资pdf
  payScalePdf(param) {
    const url = this.ydapi + '/practitioner/payScalePdf';
    return this.http
      .post(url, JSON.stringify(param));
    // this.http.post(`${this.ydapi}/practitioner/payScalePdf`, param, { responseType: 'blob', observe: 'response' }).subscribe(data => {
    //   const link = document.createElement('a');
    //   const blob = new Blob([data.body], { type: 'application/pdf;charset=UTF-8' });
    //   link.setAttribute('href', window.URL.createObjectURL(blob));
    //   link.setAttribute('download', data.headers.get('Content-Disposition').split('filename=')[1]);
    //   link.style.visibility = 'hidden';
    //   document.body.appendChild(link);
    //   link.click();
    //   document.body.removeChild(link);
    // })
  }

  applyForExpertSupport(param){
  const url = this.ydapi + '/practitioner/applyForExpertSupport';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //日程跟进查询
  queryScheduleTrackList(param){
    const url = this.ydapi + '/practitioner/queryScheduleTrackList';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //新增日程
  addScheduleTrack(param){
    const url = this.ydapi + '/practitioner/addScheduleTrack';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //PEP得分查询
  queryPEPScore(param){
    const url = this.ydapi + '/practitioner/queryPEPScore';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //PEP详情得分
  queryPEPScoreDetail(param){
    const url = this.ydapi + '/practitioner/queryPEPScoreDetail';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //删除日程
  deleteScheduleTrackById(param){
    const url = this.ydapi + '/practitioner/deleteScheduleTrackById';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //经纪人级别查询
  practitionerTypeAndLevelQuery(param){
    const url = this.API + '/metadata/practitionerTypeAndLevelQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  // 经纪人列表查询
  practitionerListQuery(typeId?: number) {
    const url = this.API + "/erp/practitionerListQuery";
     return this.http
      .post(url, JSON.stringify({typeId:typeId}));
  }

  //经纪人详情
  practitionerDetailsQuery(param) {
    const url = this.API + "/erp/practitionerDetailsQuery";
    return this.http.post(url, JSON.stringify(param));
  }

  saveMembership(param){
    const url = this.ydapi + '/practitionerHiring/saveMembership';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //证件类型&保险公司&产品险种查询接口
  erpInitialize(){
      const url = this.API + "/erp/erpInitialize";
       return this.http
        .post(url, JSON.stringify({}));
  }

  /**
   * 查询省份和城市
   * @param planId
   * @param insurerId
   * @param productId
   * @returns {Promise<any|TResult2|TResult1>}
   */
  provCityQry() {
    const url = this.API + '/metadata/provCityQry';
    return this.http
      .post(url, JSON.stringify({insurerId:11}));
  }

  //报聘基本信息
  saveBasicInfo(param){
    const url = this.ydapi + '/practitionerHiring/saveBasicInfo';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //工作经历
  saveWorkingExperience(param){
    const url = this.ydapi + '/practitionerHiring/saveWorkingExperience';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //个人资料照片
  savePersonPicture(param){
    const url = this.ydapi + '/practitionerHiring/savePersonPicture';
    return this.http
      .post(url, JSON.stringify(param));
  }
  //个人二维码照片
  saveWeChatQRcode(param){
    const url = this.ydapi + '/practitionerHiring/saveWeChatQRcode';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //薪资单流水
  savePayrollPicture(param){
    const url = this.ydapi + '/practitionerHiring/savePayrollPicture';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //身份证
  saveIDPicture(param){
    const url = this.ydapi + '/practitionerHiring/saveIDPicture';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //学历
  saveLastGraduateGrade(param){
    const url = this.ydapi + '/practitionerHiring/saveLastGraduateGrade';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //银行信息保存
  saveBankAccount(param){
    const url = this.ydapi + '/practitionerHiring/saveBankAccount';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //个人申明
  savePersonalStatements(param){
    const url = this.ydapi + '/practitionerHiring/savePersonalStatements';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //合同文档查询接口
  queryContractTerms(){
    const url = this.ydapi + '/practitionerHiring/queryContractTerms';
    return this.http
      .post(url, JSON.stringify({}));
  }

  //合同文档
  saveContractTermsConfirms(param){
    const url = this.ydapi + '/practitionerHiring/saveContractTermsConfirms';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //被邀请人填写情况查询接口
  queryWholeInfo(param){
    const url = this.ydapi + '/practitionerHiring/queryWholeInfo';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //电子签名保存
  saveDigitalSignatures(param){
    const url = this.ydapi + '/practitionerHiring/saveDigitalSignatures';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //团队成员详情
  queryTeamMemberDetail(param){
    const url = this.ydapi + '/practitioner/queryTeamMemberDetail';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //审批列表
  listQuery(param){
    const url = this.ydapi + '/practitionerHiring/listQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //审批保存接口
  // hiringApprove(param){
  //   const url = this.ydapi + '/practitionerHiring/hiringApprove';
  //   return this.http
  //     .post(url, JSON.stringify(param));
  // }
  hiringApprove(param){
      const url = this.ydapi + '/agms/practitionerHiringApprove';
      return this.http
        .post(url, JSON.stringify(param));
    }


  //ydLife审批资料详情
  detailQuery(param){
    const url = this.ydapi + '/practitionerHiring/detailQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

   /**
   * 意见反馈接口
   * @param comment
   * @returns {Promise<any|TResult2|TResult1>}
   */

  customerComment(comment) {
    const url = this.API + '/customerComment';
    return this.http
      .post(url, JSON.stringify(comment));
  }

  queryPractitionerInfo(param){
    const url = this.ydapi + '/practitionerHiring/queryPractitionerInfo';
    return this.http
      .post(url, JSON.stringify(param));
  }

    // 查询分公司
    organizationQuery(organizationInfo) {
      const url = this.API + "/erp/organizationQuery";
      return this.http
      .post(url, JSON.stringify(organizationInfo));
    }

    //最后一步保存
    hiringSubmit(param){
      const url = this.ydapi + '/practitionerHiring/hiringSubmit';
      return this.http
        .post(url, JSON.stringify(param));
      }

    //区域负责人数字权限成员业绩信息查询
    employeePerformanceForAreaManagerQuery(param){
      const url = this.ydapi + "/practitioner/employeePerformanceForAreaManagerQuery";
      return this.http.post(url, JSON.stringify(param)).pipe(res => {
        return res;
      });
    }

    //销售业绩预测  保费/佣金/件数
    employeeFCTPerformanceForAreaManagerQuery(param){
      const url = this.ydapi + "/practitioner/employeeFCTPerformanceForAreaManagerQuery";
      return this.http.post(url, JSON.stringify(param)).pipe(res => {
        return res;
      });
    }

    //区域负责人查询团队PEP得分
    pepForAreaManagerQuery(param){
      const url = this.ydapi + "/practitioner/pepForAreaManagerQuery";
      return this.http.post(url, JSON.stringify(param)).pipe(res => {
        return res;
      });
    }

    canSeeSalaryList(params){
      const url = this.ydapi + "/practitioner/canSeeSalaryList/" + params ;
      return this.http.get(url);
    }

    //文章查询列表
    practitionerFileSharingList(param){
      const url = this.ydapi + '/agms/practitionerFileSharingList';
      return this.http.post(url, JSON.stringify(param)).pipe((res)=>{
        return res;
      });
    }

    /**
   * 获取微信用户的详细信息
   */
    getWxUserInfo(trackId) {
      const url = this.API + '/getSnsApiUserInfo?trackId=' + trackId;
      return this.http.get(url).pipe((res)=>{
        return res;
      });
    }

    //保存文章code
    articleShareCodeSave(param){
      const url = this.ydapi + '/practitionerArticle/articleShareCodeSave';
      return this.http.post(url, JSON.stringify(param)).pipe((res)=>{
        return res;
      });
    }

    //保存客户痕迹
    articleTrackSave(param){
    const url = this.ydapi + '/practitionerArticle/articleTrackSave';
      return this.http.post(url, JSON.stringify(param)).pipe((res)=>{
        return res;
      });
    }

    //用户信息跟踪
    articleTrackQuery(practitionerId,sharingId){
      const url = this.ydapi + '/practitionerArticle/articleTrackQuery?practitionerId=' + practitionerId + '&sharingId=' + sharingId;
      return this.http.get(url).pipe((res)=>{
        return res;
      });
    }

    //佣金列表
  querySalaryDetail(param){
    const url = this.ydapi + '/practitioner/querySalaryDetail';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //薪资对应保单的接口
  searchStaffSalaryDetails(param){
    const url = this.ydapi + '/practitioner/searchStaffSalaryDetails';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //提现订单接口
  fortuneWithdrawListQuery(param){
    const url = this.API + "/fortuneWithdrawListQuery";
    return this.http
    .post(url, JSON.stringify(param));
  }

  //场景查询
  tagViewQuery(param){
    const url = this.ydapi + "/metadata/tagViewQuery";
    return this.http
    .post(url, JSON.stringify(param));
  }

  //根据标签查询产品库标签
  queryProductBox(param){
    const url = this.API + "/erp/queryProductBox";
    return this.http
    .post(url, JSON.stringify(param));
  }

  //查询产品对应的文件
  queryProductFile(param){
    const url = this.API + "/erp/queryProductFile";
    return this.http
    .post(url, JSON.stringify(param));
  }

  //我的客户投保人列表列表
  queryCustomerHolderList(practitionerId){
    const url = this.ydapi + `/practitioner/queryCustomerHolderList/${practitionerId}`
    return this.http.get(url).pipe((res)=>{
      return res;
    });
  }

  //客户关系接口
  queryCustomerInsuredList(param){
    const url = this.ydapi + `/practitioner/queryCustomerInsuredList`
    return this.http.post(url,JSON.stringify(param)).pipe((res)=>{
      return res;
    });
  }

  //客户保单查询接口
  queryPolicyListByHolderCustomerId(param){
    const url = this.ydapi + '/practitioner/queryPolicyListByHolderCustomerId';
    return this.http.post(url, JSON.stringify(param));
  }

  //保单详情接口
  orderDetailQuery(param) {
    const url = this.API + '/erp/orderDetailQuery';
    return this.http.post(url, JSON.stringify(param));
  }

  //查询核保问题知识
  underwritingProblemQuery(param){
    const url = this.API + "/erp/underwritingProblemQuery";
    return this.http.post(url, JSON.stringify(param));
  }

  //投核保问题保存
  underwritingProblemSave(param){
    const url = this.API + "/erp/underwritingProblemSave";
    return this.http.post(url, JSON.stringify(param));
  }

   //产品名称
   productQry(objParam) {
    const url = this.API + "/metadata/productQry";
    return this.http.post(url, JSON.stringify(objParam));
  }

  // 保存客户告知书分享信息
  saveInformedSheet(objParam) {
    const url = this.ydapi + "/practitioner/saveInformedSheet";
    return this.http.post(url, JSON.stringify(objParam));
  }

  // 获取客户告知书分享信息

  queryInformedSheetById(objParam) {
    const url = this.ydapi + "/practitioner/queryInformedSheetById";
    return this.http.post(url, JSON.stringify(objParam));
  }
  // 保存客户签名
  signInformedSheet(objParam) {
    const url = this.ydapi + "/practitioner/signInformedSheet";
    return this.http.post(url, JSON.stringify(objParam));
  }

  // 查询电子告知书列表
  queryInformedSheetList(param){
    const url = this.ydapi + "/practitioner/queryInformedSheetList";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
        return res;
    });
  }

   /**
   *  用户退出登录
   */
    erpLogout(objParam) {
      const url = this.API + "/erp/erpLogout";
      return this.http.post(url, JSON.stringify(objParam)).pipe(res => {
        return res;
      });
    }

    //继续率承诺书签署
    signCommitment(param){
      const url = this.ydapi + "/practitioner/signCommitment";
      return this.http.post(url, JSON.stringify(param));
    }

    //查询继续率承诺书
    queryCommitmentByPractitionerId(param){
      const url = this.ydapi + "/practitioner/queryCommitmentByPractitionerId";
      return this.http.post(url, JSON.stringify(param));
    }

    /**
   * 用户行为跟踪
   * @returns {Observable<A>}
   */
  customerBehaviorTrackSave(processMemo) {
    const url = this.API + '/customerBehaviorTrackSave';
    const behaviorInfo = {
        'serialsNo': null,
        'customerId': localStorage.getItem('lifeCustomerInfo') ? JSON.parse(localStorage.getItem('lifeCustomerInfo')).customerId : null,
        'orderId': null,
        'processMemo': processMemo,
        'mediaFrom': '银盾保经'
      };
    return this.http.post(url, JSON.stringify(behaviorInfo));
  }

  /**
   * 可回溯录屏接口
   */
   rrwebInfo(events,pageInfo){
    if (!sessionStorage.getItem('lifeSerialsNo')) sessionStorage.setItem('lifeSerialsNo',uuid.v4());
    let csId = JSON.parse(localStorage.getItem('lifeCustomerInfo')) ? JSON.parse(localStorage.getItem('lifeCustomerInfo')).customerId : '';
    if(sessionStorage.getItem('inviteeCustomerId')) csId = sessionStorage.getItem('inviteeCustomerId');
    const param = {
      serialsNo:sessionStorage.getItem('lifeSerialsNo'),
      customerId:csId,
      token:localStorage.getItem('lifeToken'),
      pageType:pageInfo.type,
      pageName:pageInfo.name,
      url:location.href,
      data:JSON.stringify(events)
    };
    const url = this.ydapi + "/customerTrackVideo/rrwebInfo"
    return this.http.post(url,JSON.stringify(param))
  }

  // 跟踪登录接口查询customerId
  login(params){
    const url = this.API + "/login"
    return this.http.post(url,JSON.stringify(params))
  }
  // 查询联合销售列表信息接口
  queryUnionSalesList(params){
    const url = this.API + "/unionSales/queryUnionSalesList"
    return this.http.post(url,JSON.stringify(params))
  }
  // 查询联合销售列表信息接口
  queryUnionSalesPractitionerList(params){
    const url = this.API + "/unionSales/queryUnionSalesPractitionerList"
    return this.http.post(url,JSON.stringify(params))
  }
  // 经纪人联合销售签名
  signUnionSales(params){
    const url = this.ydapi + "/practitioner/signUnionSales"
    return this.http.post(url,JSON.stringify(params))
  }
  // 续期提醒列表查询接口
  queryNoticeList(params){
    const url = this.API + "/orderPay/queryNoticeList"
    return this.http.post(url,JSON.stringify(params))
  }
  // 续期提醒通知接口
  addNotice(params){
    const url = this.API + "/orderPay/addNotice";
    return this.http.post(url,JSON.stringify(params))
  }
  //  续期提醒通知详情接口
  queryNoticeDetail(params){
    const url = this.API + "/orderPay/queryNoticeDetail";
    return this.http.post(url,JSON.stringify(params))
  }
  // 经纪人积分总数状态
  queryPractitionerIntegral(params){
    const url = this.API + "/integral/queryPractitionerIntegral";
    return this.http.post(url,JSON.stringify(params))
  }
  // 积分明细查询
  queryPractitionerIntegralList(params){
    const url = this.API + "/integral/queryPractitionerIntegralList";
    return this.http.post(url,JSON.stringify(params))
  }
  // 积分规则信息
  queryIntegralRuleList(){
    const url = this.API + "/integral/queryIntegralRuleList";
    return this.http.post(url,JSON.stringify({isActive:1}))
  }

  // 删除商机
  deleteOpportunity(params){
    const url = this.ydapi + "/practitioner/deleteOpportunity";
    return this.http.post(url,JSON.stringify(params))
  }

  // 经纪人名片
  businessCard(params){
    const url = this.ydapi + "/practitioner/businessCard";
    return this.http.post(url,JSON.stringify(params))
  }

  // 申请公司邮箱
  applyEmail(params){
    const url = this.ydapi + "/practitioner/applyEmail";
    return this.http.post(url,JSON.stringify(params))
  }

  // 保存视频播放轨迹接口 https://mdev.zuihuibi.cn/api/saveVideoPlayback
  // 请求信息(定时20s调用一次、或者暂停、离开浏览器、退出等可监控点调用)
  saveVideoPlayback(params){
    const url = this.API + "/videoPlay/saveVideoPlayback";
    return this.http.post(url,JSON.stringify(params))
  }
  // 
  // 调用该接口【获取视频的播放轨迹列表】与【获取上次播放时间点】
  queryVideoPlayback(params){
    const url = this.API + "/videoPlay/queryVideoPlayback";
    return this.http.post(url,JSON.stringify(params))
  }

  // 讲师信息查询
  lecturerQuery(params){
    const url = this.API + "/college/lecturerQuery";
    return this.http.post(url,JSON.stringify(params))
  }

  // 消息列表
  querySystemMessage(params){
    const url = this.API + "/systemMessage/querySystemMessage";
    return this.http.post(url,JSON.stringify(params))
  }

  // 消息详情
  querySystemMessageDetail(params){
    const url = this.API + "/systemMessage/querySystemMessageDetail";
    return this.http.post(url,JSON.stringify(params))
  }

  // 一键已读
  oneKeyRead(params){
    const url = this.API + "/systemMessage/oneKeyRead";
    return this.http.post(url,JSON.stringify(params))
  }

  //我的管理个人数据
  personalCompletionRate(params){
    const url = this.API + "/videoPlay/personalCompletionRate";
    return this.http.post(url,JSON.stringify(params))
  }

  //我的管理团队数据
  teamCompletionRate(params){
    const url = this.API + "/videoPlay/teamCompletionRate";
    return this.http.post(url,JSON.stringify(params))
  }

  //学习明细接口
  queryLearningProgressDetail(params){
    const url = this.API + "/videoPlay/queryLearningProgressDetail";
    return this.http.post(url,JSON.stringify(params))
  }
}
