import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'switchNumber'
})
export class SwitchNumberPipe implements PipeTransform {

  transform(value: any, args?: any): any {
    if ((value + "").trim() == "") {
      return "";
    }
    if (typeof value == 'string') {
      value = value.replace(/,/gi, '');
    }
    if ((value + "").trim() == "") {
      return "";
    }
    if (isNaN(value)) {
      return "";
    }
    value = value + "";
    if (/^.*\..*$/.test(value)) {
      let pointIndex = value.lastIndexOf(".");
      let intPart = value.substring(0, pointIndex);
      let pointPart = value.substring(pointIndex + 1, value.length);
      intPart = intPart + "";
      const re = /(-?\d+)(\d{3})/
      while (re.test(intPart)) {
        intPart = intPart.replace(re, "$1,$2")
      }
      value = intPart + "." + pointPart;
    } else {
      value = value + "";
      var re = /(-?\d+)(\d{3})/
      while (re.test(value)) {
        value = value.replace(re, "$1,$2")
      }
    }
    return value;
  }

}
