import {BrowserModule} from '@angular/platform-browser';
import {NgModule} from '@angular/core';
import {AppRoutingModule} from './app-routing.module';
import {AppComponent} from './app.component';
import {PageNotFoundComponent} from './page-not-found/page-not-found.component';
import {MyModule} from './my/my.module';
import {Router} from '@angular/router';
import {AuthModule} from './auth/auth.module';
import {HttpClientModule} from '@angular/common/http';
import {LifeCommonModule} from './common/life-common.module';
import {httpInterceptorProviders} from './http-interceptors/index';
import {DatePipe} from "@angular/common";
import { SafeHtmlPipe } from './safe-html.pipe';

@NgModule({
  declarations: [
    AppComponent,
    PageNotFoundComponent,
    SafeHtmlPipe
  ],
  imports: [
    BrowserModule,
    MyModule,
    AuthModule,
    LifeCommonModule,
    HttpClientModule,
    AppRoutingModule
  ],
  providers: [DatePipe, httpInterceptorProviders],
  bootstrap: [AppComponent]
})
export class AppModule {
}
