import { Component, OnInit } from '@angular/core';
import { ActivatedRoute,Router } from "@angular/router";
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-salary-first-year',
  templateUrl: './salary-first-year.component.html',
  styleUrls: ['./salary-first-year.component.scss']
})
export class SalaryFirstYearComponent implements OnInit {
  status:boolean;
  //判断跳转页用的
  type:any;
  //佣奖名称
  salaryName:any;
  //佣奖类型-》用来判断拿保单接口中的哪个数据
  salaryType:any;
  month:any;
  years:any;
  agent_id:any;
  //保单列表
  policyList:Array<any>;
  //体系列表
  systemList:Array<any>;
  //备注
  remarkInfo:any;
  //其他加扣款列表
  OtherCommissionList:Array<any>;
  withdrawId:any;
  customerFortuneWithdraws:Array<any>;
  isBasic:any;
  constructor(private activatedRoute: ActivatedRoute,private myService:MyService) { }

  ngOnInit() {
    this.type = this.activatedRoute.snapshot.queryParams.type?this.activatedRoute.snapshot.queryParams.type:null;
    this.salaryName = this.activatedRoute.snapshot.queryParams.salaryName?this.activatedRoute.snapshot.queryParams.salaryName:null;
    this.salaryType = this.activatedRoute.snapshot.paramMap.get('id');
    this.years = this.activatedRoute.snapshot.queryParams.years?this.activatedRoute.snapshot.queryParams.years:null;
    this.month = this.activatedRoute.snapshot.queryParams.month?this.activatedRoute.snapshot.queryParams.month:null;
    this.agent_id = this.activatedRoute.snapshot.queryParams.agent_id?this.activatedRoute.snapshot.queryParams.agent_id:null;
    this.isBasic = this.activatedRoute.snapshot.queryParams.isBasic?this.activatedRoute.snapshot.queryParams.isBasic:null;
    this.searchStaffSalaryDetails();
  }

  goBack(){
    history.go(-1);
  }

  /**
   * salaryTaype
   * 1.首年度销售佣金-》保单
   * 2.月度销售加码奖/续年度销售佣金/独立经纪人展业津贴/续年度销售加码奖金-》保单
   * 3.首年度辅导奖金-》保单
   * 4.续年度辅导奖金-》保单
   * 5.首年度绩效奖金-》体系
   * 6.续年度绩效奖金/直接辅导岗位津贴/隔代辅导岗位津贴/育成奖金/团队长辅导津贴-》体系
   * 7.推介奖金-》保单
   * 8.体系推介奖金-》体系
   * 9.特别管理奖金-》保单
   * 10.其它税前加扣款-》备注
   * 11.公司激励奖金-》备注
   * 12.加码奖金-》备注
   * 13.季度奖金-》备注
   * 14.银盾在线佣金-》H5
   */
  searchStaffSalaryDetails(){
    const param = {
      years:this.years,
      month:this.month,
      agent_id:this.agent_id,
      practitionerId:JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'],
      isBasic:this.isBasic
    }
    this.myService.searchStaffSalaryDetails(param).subscribe((res)=>{
      if(res['data']){
        if(this.salaryType == 1){
          this.policyList = res['data']['FristYearCommissionList'];
        }else if(this.salaryType == 2){
          this.policyList = res['data']['RenewalYearCommissionList'];
        }else if(this.salaryType == 3){
          this.policyList = res['data']['FristYearCoachCommissionList'];
        }else if(this.salaryType == 4){
          this.policyList = res['data']['RenewalYearCoachCommissionList'];
        }else if(this.salaryType == 5){
          this.systemList = res['data']['FirstYearPerformanceCommissionList'];
        }else if(this.salaryType == 6){
          this.systemList = res['data']['RenewalYearPerformanceCommissionList'];
        }else if(this.salaryType == 7){
          this.policyList = res['data']['RecommendCommissionList'];
        }else if(this.salaryType == 8){
          this.systemList = res['data']['RecommendSystemCommissionList'];
        }else if(this.salaryType == 9){
          this.policyList = res['data']['SpecialManagementCommissionList'];
        }else{
          this.OtherCommissionList = res['data']['OtherCommissionList'];
          if(this.OtherCommissionList && this.OtherCommissionList.length){
            for(let i=0;i<this.OtherCommissionList.length;i++){
              if(this.salaryType == 10 && this.OtherCommissionList[i]['Project_Id'] == '91E8A0DD-8696-9964-CD35-AEBA6C8FDF19'){
                this.remarkInfo = this.OtherCommissionList[i];
              }else if(this.salaryType == 11 && this.OtherCommissionList[i]['Project_Id'] == '45C0E205-653A-641B-1A35-C5C4148B1DA6'){
                this.remarkInfo = this.OtherCommissionList[i];
              }else if(this.salaryType == 12 && this.OtherCommissionList[i]['Project_Id'] == 'FC664684-4CBB-E3EC-FEC4-02FDDCAB4A02'){
                this.remarkInfo = this.OtherCommissionList[i];
              }else if(this.salaryType == 13 && this.OtherCommissionList[i]['Project_Id'] == '105B9197-7B64-5AE6-AC47-C15AA857DDC5'){
                this.remarkInfo = this.OtherCommissionList[i];
              }else if(this.salaryType == 14 && this.OtherCommissionList[i]['Project_Id'] == '12C24EDF-83D7-081C-AE2C-085031C4DCAF'){
                //银盾在线佣金
                this.remarkInfo = this.OtherCommissionList[i];
                this.withdrawId = this.OtherCommissionList[i]['withdrawedId'];
                this.fortuneWithdrawListQuery()
              }
            }
          }
        }
      }
    })
  }


  //查询银盾在线佣金对应的保单
  fortuneWithdrawListQuery() {
    const param = {
      customerId:JSON.parse(localStorage.getItem('lifeCustomerInfo'))['customerId'],
      paginationInfo: {noLimitFlag: "CONFIRM"},
      withdrawStatus: "drawn",
      withdrawId:this.withdrawId
    }
    if(this.withdrawId){
      this.myService.fortuneWithdrawListQuery(param).subscribe(res => {
        if (res['success']) {
          this.customerFortuneWithdraws = res['data']['customerFortuneWithdraws'];
        }
      });
    }else{
      this.customerFortuneWithdraws = [];
    }
  }

  shrink(policyItem){
    policyItem.status = !policyItem.status;
  }
}
