import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { MyCenterHomeComponent } from './my-center-home/my-center-home.component';
import { AuthGuard } from '../auth/auth.guard';
import { MkMaterialComponent } from './mk-material/mk-material.component';
import { MkMaterialDetailComponent } from './mk-material-detail/mk-material-detail.component';
import { FileUploadComponent } from './file-upload/file-upload.component';
import { ImportantAnnouncementComponent } from './important-announcement/important-announcement.component';
import { SalesDetailComponent } from './sales-detail/sales-detail.component';
import { AnnouncementDetailComponent } from './announcement-detail/announcement-detail.component';
import { MyBusinessComponent } from './my-business/my-business.component';
import { MyBusinessDetailComponent } from './my-business-detail/my-business-detail.component';
import { SalesRankComponent } from './sales-rank/sales-rank.component';
import { TeamRankComponent } from './team-rank/team-rank.component';
import { RecruitingComponent } from './recruiting/recruiting.component';
import { RecruitingDetailComponent } from './recruiting-detail/recruiting-detail.component';
import { ThanksComponent } from './thanks/thanks.component';
import { MySettingComponent } from './my-setting/my-setting.component';
import { MySettingDetailComponent } from './my-setting-detail/my-setting-detail.component';
import { MyNewsComponent } from './my-news/my-news.component';
import { MyTargetComponent } from "./my-target/my-target.component";
import { TeamPanelComponent } from './team-panel/team-panel.component';
import {BusinessCardComponent} from "./business-card/business-card.component";

const myRoutes: Routes = [
  { path: '', component: MyCenterHomeComponent, canActivate: [AuthGuard], data: [{ title: '银盾保险经纪 - 工作台' }] },
  { path: 'material', component: MkMaterialComponent, canActivate: [AuthGuard] },
  { path: 'material/:itemId', component: MkMaterialDetailComponent, canActivate: [AuthGuard] },
  { path: 'fileUpload', component: FileUploadComponent, canActivate: [AuthGuard], data: [{ type: 'fileUpload' }] },
  { path: 'training', component: FileUploadComponent, canActivate: [AuthGuard], data: [{ type: 'training' }] },
  { path: 'importantAnnouncement', component: ImportantAnnouncementComponent, canActivate: [AuthGuard] },
  { path: 'salesDetail', component: SalesDetailComponent, canActivate: [AuthGuard] },
  { path: 'importantAnnouncement/:id', component: AnnouncementDetailComponent, canActivate: [AuthGuard] },
  { path: 'business', component: MyBusinessComponent, canActivate: [AuthGuard] },
  { path: 'business/:id', component: MyBusinessDetailComponent, canActivate: [AuthGuard] },
  { path: 'rank', component: SalesRankComponent, canActivate: [AuthGuard] },
  { path: 'teamRank', component: TeamRankComponent, canActivate: [AuthGuard] },
  { path: 'recruiting', component: RecruitingComponent, canActivate: [AuthGuard] },
  { path: 'recruiting/:id', component: RecruitingDetailComponent, canActivate: [AuthGuard] },
  { path: 'thanks', component: ThanksComponent, canActivate: [AuthGuard] },
  { path: 'setting', component: MySettingComponent, canActivate: [AuthGuard] },
  { path: 'setting/:uploadType', component: MySettingDetailComponent, canActivate: [AuthGuard] },
  { path: 'news', component: MyNewsComponent, canActivate: [AuthGuard] },
  { path: 'target', component: MyTargetComponent, canActivate: [AuthGuard] },
  { path: 'teamPanel', component: TeamPanelComponent, canActivate: [AuthGuard] },
  { path: 'businessCard', component: BusinessCardComponent, canActivate: [AuthGuard] },

];

@NgModule({
  imports: [RouterModule.forChild(myRoutes)],
  exports: [RouterModule]
})
export class MyRoutingModule {
}
