import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { LifeCommonService } from '../../common/life-common.service';
@Component({
  selector: 'ydlife-my-question',
  templateUrl: './my-question.component.html',
  styleUrls: ['./my-question.component.scss']
})
export class MyQuestionComponent implements OnInit {
  practitionerId:any;
  List:Array<any>;
  constructor(public lifeCommonService: LifeCommonService,private myService:MyService) { }

  ngOnInit() {
    this.lifeCommonService.setTitle('我的问题');
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.searchList()
  }

  
  searchList(){
    const param = {
      isActive:1,
      questioner:this.practitionerId
    }
    this.myService.underwritingProblemQuery(param).subscribe((res)=>{
      if(res['success']){
        this.List = res['data']['problemItems'];
      }
    })
  }

  //已读保存
  underwritingProblemSave(listItem){
    if(listItem.isView == '0'){
      let Param = {
        ...listItem,
        isView:'1'
      }
      this.myService.underwritingProblemSave(Param).subscribe((res)=>{
        if(res['success']){
         listItem.isView = '1';
        }
      })
    }
  }

  isShrinkis(listItem){
    if(listItem.answer){
      listItem.spread = !listItem.spread
    }
  }
}
