import {Component, OnInit} from '@angular/core';
import {LifeCommonService} from "../../common/life-common.service";
import {MyService} from "../my.service";
import {ActivatedRoute} from "@angular/router";

@Component({
  selector: 'ydlife-file-upload',
  templateUrl: './file-upload.component.html',
  styleUrls: ['./file-upload.component.scss']
})
export class FileUploadComponent implements OnInit {
  fileUploadItemList: Array<any>;
  // 判断是文件下载还是教育培训
  type: string;

  constructor(private myService: MyService, private activatedRoute: ActivatedRoute) {
  }

  ngOnInit() {
    this.type = this.activatedRoute.snapshot.data[0]['type'];
    if (this.type === 'fileUpload') {
      this.fileUpload(3, 0, 19);
    } else if (this.type === 'training') {
      this.fileUpload(3, 0, 23);
    }

  }

//  文件下载
  fileUpload(itemType, itemId, fileCategory) {
    this.myService.filePath(itemType, itemId, fileCategory).subscribe(res => {
      if (res['success']) {
        this.fileUploadItemList = res['data']['fileUploadItemList'];
      }
    });
  }

}
