import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DatePipe } from "@angular/common";
import { MyRoutingModule } from './my-routing.module';
import { MyCenterHomeComponent } from './my-center-home/my-center-home.component';
import { LifeCommonModule } from "../common/life-common.module";
import { MkMaterialComponent } from './mk-material/mk-material.component';
import { MkMaterialDetailComponent } from './mk-material-detail/mk-material-detail.component';
import { FileUploadComponent } from './file-upload/file-upload.component';
import { ImportantAnnouncementComponent } from './important-announcement/important-announcement.component';
import { SalesDetailComponent } from './sales-detail/sales-detail.component';
import { AnnouncementDetailComponent } from './announcement-detail/announcement-detail.component';
import { MyBusinessComponent } from './my-business/my-business.component';
import { MyBusinessDetailComponent } from './my-business-detail/my-business-detail.component';
import { PickerComponent } from '../common/picker/picker.component';
import { ToastComponent } from '../common/toast/toast.component';
import { SalesRankComponent } from './sales-rank/sales-rank.component';
import { TeamRankComponent } from './team-rank/team-rank.component';
import { RecruitingComponent } from './recruiting/recruiting.component';
import { RecruitingDetailComponent } from './recruiting-detail/recruiting-detail.component';
import { ThanksComponent } from './thanks/thanks.component';
import { MySettingComponent } from './my-setting/my-setting.component';
import { MySettingDetailComponent } from './my-setting-detail/my-setting-detail.component';
import { MyNewsComponent } from './my-news/my-news.component';
import { MyTargetComponent } from './my-target/my-target.component';
import { TeamPanelComponent } from './team-panel/team-panel.component';
import { SwitchNumberPipe } from '../common/pipe/switch-number.pipe';
import { TeamSalesScoreComponent } from './team-sales-score/team-sales-score.component';
import { ScoreDetailsComponent } from './score-details/score-details.component';
import { BusinessCardComponent } from './business-card/business-card.component';
import { OrderDetailComponent } from './order-detail/order-detail.component';
import { SalaryComponent } from './salary/salary.component';
import { TodoListComponent } from './todo-list/todo-list.component';
import { AddTaskComponent } from './add-task/add-task.component';

@NgModule({
  declarations: [MyCenterHomeComponent, MkMaterialComponent, MkMaterialDetailComponent, FileUploadComponent, ImportantAnnouncementComponent, SalesDetailComponent, AnnouncementDetailComponent, MyBusinessComponent, MyBusinessDetailComponent, PickerComponent, ToastComponent, SalesRankComponent, TeamRankComponent, RecruitingComponent, RecruitingDetailComponent, ThanksComponent, MySettingComponent, MySettingDetailComponent, MyNewsComponent, MyTargetComponent, TeamPanelComponent, SwitchNumberPipe, TeamSalesScoreComponent, ScoreDetailsComponent, BusinessCardComponent, OrderDetailComponent, SalaryComponent, TodoListComponent, AddTaskComponent],
  imports: [
    CommonModule,
    LifeCommonModule,
    MyRoutingModule,
  ],
  providers: [
    DatePipe
  ]
})
export class MyModule {
}
