import { Component, OnInit } from '@angular/core';
import {MyService} from '../my.service';
@Component({
  selector: 'ydlife-add-task',
  templateUrl: './add-task.component.html',
  styleUrls: ['./add-task.component.scss']
})
export class AddTaskComponent implements OnInit {
  tabList:Array<any>;
  tabType:string;
  salesActivityList:Array<any>;
  taskImportantTag:boolean = false;
  constructor(private myService:MyService) { }

  ngOnInit() {
    this.tabList = [{code:'bizchance_promotion_action',name:'营销'},{code:'team_building_source',name:'增员'},{code:'pep_schedule_task_others',name:'其他'}];
    this.tabType = 'bizchance_promotion_action';
    this.dropOptionsQuery(this.tabType)
  }

  goBack(){
    history.go(-1);
  }

  selectTab(code){
    this.tabType = code;
  }

  dropOptionsQuery(code){
    this.myService.dropOptionsQuery({code:code}).subscribe((res)=>{
      if(res['success']){
        this.salesActivityList = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'];
        console.log(this.salesActivityList)
      }
    })
  }
}
