import {Component, ElementRef, OnInit, ViewChild} from '@angular/core';
import {ActivatedRoute} from '@angular/router';
import {environment} from '../../../environments/environment';
import {LifeCommonService} from '../../common/life-common.service';
import {MyService} from '../my.service';
declare var QRCode: any;
@Component({
  selector: 'ydlife-mk-material-detail',
  templateUrl: './mk-material-detail.component.html',
  styleUrls: ['./mk-material-detail.component.scss']
})
export class MkMaterialDetailComponent implements OnInit {
  @ViewChild('canvas') canvas: ElementRef<any>;
  materialItemId: string;
  lifeCustomerInfo: any;
  shareInfo: any;

  constructor(private activateRoute: ActivatedRoute,
              private lifeCommonService: LifeCommonService,
              private myService: MyService) {
  }

  ngOnInit() {
    this.materialItemId = this.activateRoute.snapshot.paramMap.get('itemId');
    this.lifeCustomerInfo = localStorage.getItem('lifeCustomerInfo') ? JSON.parse(localStorage.getItem('lifeCustomerInfo')) : null;
    // 分享信息
    this.shareInfo = {
      ...this.lifeCommonService.generateShareCode(),
      customerId: this.lifeCustomerInfo.customerId,
      productId: this.materialItemId,
      url: `${environment.ORIGINNAME}/life/${this.materialItemId}?shareCode=${this.lifeCommonService.generateShareCode().shareCode}`
    };
    // 发送请求保存分享码
    this.shareCallBack();
  }

  download(canvas) {
    const a = document.createElement('a');
    // 设置地址
    a.href = canvas.toDataURL('image/png', 1);
    // 设置下载名称
    a.download = '银盾保险经纪';
    // 触发点击事件
    a.click();
  }

  canvasPic() {
    this.canvas.nativeElement.width = window.screen.width;
    this.canvas.nativeElement.height = window.screen.height;
    const canvas = this.canvas.nativeElement as HTMLCanvasElement;
    canvas.width = canvas.width * 1;
    canvas.height = canvas.height * 1;
    const qr = document.querySelector('#qrcode');
    const ctx = canvas.getContext('2d');
    const img = new Image();
    // // 这里的第一张图片就是可以是你们的海报 这里注意绘制的顺序 我们要手动控制
    img.src = `${environment.ORIGINNAME}/ydLife/assets/images/mk-material/${this.materialItemId}.jpg`;
    img.onload = () => {
      ctx.drawImage(img, 0, 0, this.canvas.nativeElement.width, this.canvas.nativeElement.height);
      // 对二维码进行初始化
      const qrCode = new QRCode(qr, {
        width: 100,
        height: 100,
        colorDark: '#000000',
        colorLight: '#ffffff',
      });
      // 为二维码设置内容
      qrCode.makeCode(this.shareInfo.url);
      // 我们的qrcode生成二维码之后也会有一个canvas对象我们获取到这个元素
      const newCanvas = qr.firstChild as HTMLCanvasElement;
      const base64 = newCanvas.toDataURL('image/png', 1);
      // 这里的image只能在onload里面绘制 在外面就会被覆盖了 因为优先加载完毕就会优先绘制 然后就被之后绘制的海报背景遮挡了
      const shareQr = new Image();
      // 设置base64编码格式值
      shareQr.src = base64;
      shareQr.onload = () => {
        // 绘制图像  就是绘制二维码到我们自己写的canvas中去
        ctx.drawImage(shareQr, this.canvas.nativeElement.width - 120, this.canvas.nativeElement.height - 125, 100, 100);
        document.querySelector('#bannerImg').setAttribute('src', canvas.toDataURL('image/png', 1));
        this.canvas.nativeElement.style.display = 'none';
      };
      // 绘制字体
      ctx.font = '14px 微软雅黑';
      ctx.fillStyle = '#081a71';
      ctx.fillText('长按了解详情', this.canvas.nativeElement.width - 115, this.canvas.nativeElement.height - 8);
      ctx.fillText(`银盾保险经纪 ${this.lifeCustomerInfo['practitionerBasicInfo']['name']}`, 15, this.canvas.nativeElement.height - 100);
      ctx.fillText(`手机号：${this.lifeCustomerInfo.mobileNo}`, 15, this.canvas.nativeElement.height - 70);
      ctx.fillText('微信号：123456', 15, this.canvas.nativeElement.height - 40);
    };
  }

  shareCallBack() {
    this.myService.shareCallBack(this.shareInfo).subscribe(res => {
      if (res['success']) {
        this.canvasPic();
      } else {

      }
    });
  }

}
