import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-my-news',
  templateUrl: './my-news.component.html',
  styleUrls: ['./my-news.component.scss']
})
export class MyNewsComponent implements OnInit {
  private customerInfo:any;
  public newsLists = [
    {id:'01',title:'银盾保险经纪董事长欢迎信',context:'',link:'/thanks',createdAt:'',isCommonDetsil:false,isRead:'1'},
    {id:'000',title:'银盾保险经纪置顶公众号操作指南',context:'',link:'/newsDetail',createdAt:'',isCommonDetsil:true,isRead:'1'},
  ]


  goDetail(val){
    if(val.isCommonDetsil){
      this.router.navigate([val.link,val.id])
    }else{
      this.router.navigate([val.link])
    }
  }

  // 查询消息列表
  querySystemMessage(){
    const param = {
      practitionerId:this.customerInfo.practitionerId
    }
    this.myService.querySystemMessage(param).subscribe(res=>{
      console.log(res);
      if(res['success']){
        res['data']['dataList'].forEach(item=>{
          item.link = '/newsDetail';
          item.isCommonDetsil = true;
        })
        // 赋值前先初始化
        this.newsLists = [
          {id:'000',title:'银盾保险经纪董事长欢迎信',context:'',link:'/thanks',createdAt:'',isCommonDetsil:false,isRead:'1'},
          {id:'000',title:'银盾保险经纪置顶公众号操作指南',context:'',link:'/newsDetail',createdAt:'',isCommonDetsil:true,isRead:'1'}
        ]
        this.newsLists = this.newsLists.concat(res['data']['dataList']);
      }
    })
  }

  // 一键已读
  oneKeyRead(){
    this.myService.oneKeyRead({practitionerId:this.customerInfo.practitionerId}).subscribe(res=>{
      if(res['success']){
        this.querySystemMessage()
      }
    })
  }
  constructor(private router:Router,private myService:MyService) { }

  ngOnInit() {
    this.customerInfo = JSON.parse(localStorage.getItem('lifeCustomerInfo')) ? JSON.parse(localStorage.getItem('lifeCustomerInfo')) : null;
    this.querySystemMessage();
  }

}
