import { Component, OnInit } from '@angular/core';
import { MyService } from "../my.service";
import { ActivatedRoute } from "@angular/router";

@Component({
  selector: 'ydlife-file-upload',
  templateUrl: './file-upload.component.html',
  styleUrls: ['./file-upload.component.scss']
})
export class FileUploadComponent implements OnInit {
  fileUploadItemList: Array<any>;
  // 判断是文件下载还是教育培训还是培训视频
  type: string;
  categoryList: Array<any>;
  selectedCategoryId: any;
  fileUploadType:any;
  constructor(private myService: MyService, private activatedRoute: ActivatedRoute) {
  }
  setVideoPath(p){
    sessionStorage.setItem('videoPath',p);
  }

  ngOnInit() {
    this.type = this.activatedRoute.snapshot.data[0]['type'];
    if(this.type === 'trainingVideo'){
      this.fileUploadType = true;
    }else{
      this.fileUploadType = this.activatedRoute.snapshot.queryParams.fileUploadType ? this.activatedRoute.snapshot.queryParams.fileUploadType : null;
    }
    this.dropOptionsQuery();
    if (this.type === 'fileUpload') {
        this.fileUpload(3, 0, 19, 'yd_download_file_type', this.selectedCategoryId);
    } else if (this.type === 'training') {
      this.fileUpload(3, 0, 23, 'yd_trainning_file_type', this.selectedCategoryId);
    } else if (this.type === 'trainingVideo') {
      this.fileUpload(3, 0, 23, 'yd_trainning_file_type', 'trainingVideo');
    }
  }
  // 判断是不是视频文件
  judgmentFile(picUrl) {
    let filename = picUrl; //文件路径地址
    let index1 = filename.lastIndexOf(".");
    let index2 = filename.length;
    let postf = filename.substring(index1, index2); //获取文bai件后缀名duzhi
    //判断文件后缀名是否等于视频文件的后缀名
    if (postf===".avi"||postf===".mp4"||postf===".rmvb") {
      return true
    }else{
      return false
    }
  }

  //  文件下载
  fileUpload(itemType, itemId, fileCategory, code, mdDropOptionId) {
    this.myService.filePath(itemType, itemId, fileCategory, code, mdDropOptionId).subscribe(res => {
      if (res['success']) {
        this.fileUploadItemList = res['data']['fileUploadItemList'];
      }
    });
  }

  //培训资料分类
  dropOptionsQuery() {
    const code = this.type === 'fileUpload' ? 'yd_download_file_type' : 'yd_trainning_file_type'
    this.myService.dropOptionsQuery({ code: code }).subscribe(res => {
      if (res['success']) {
        this.categoryList = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'];
        if (this.categoryList.length > 0) {
          if(this.fileUploadType){
            if(this.fileUploadType == 'management'){
              this.selectedCategoryId = 'salestopic';
            }else if(this.fileUploadType == 'introduce'){
              this.selectedCategoryId = 'conception';
            }else if(this.fileUploadType == 'newRecruits'){
              this.selectedCategoryId = 'userPackage';
            }else if(this.fileUploadType == 'commissionPolicy'){
              this.selectedCategoryId = 'product';
            }
          }else{
            this.selectedCategoryId = this.categoryList[0].dropOptionCode;
          }
          this.switchCategory(this.selectedCategoryId)
        }
      } else {
        this.categoryList = [];
      }
    })
  }

  switchCategory(e) {
    this.selectedCategoryId = e;
    if (this.type === 'fileUpload') {
      this.fileUpload(3, 0, 19, 'yd_download_file_type', this.selectedCategoryId);
    } else if (this.type === 'training') {
      this.fileUpload(3, 0, 23, 'yd_trainning_file_type', this.selectedCategoryId);
    }
  }
}
