import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from "@angular/router";
import { LifeCommonService } from '../../common/life-common.service';
import { MyService } from '../my.service';
import { RecruitingQuery } from '../../domain/recruitingQuery';

@Component({
  selector: 'ydlife-recruiting-detail',
  templateUrl: './recruiting-detail.component.html',
  styleUrls: ['./recruiting-detail.component.scss']
})
export class RecruitingDetailComponent implements OnInit {
  editRecruiting: RecruitingQuery = new RecruitingQuery();
  //潜在增员的id
  id: string;
  titleList: Array<any>;
  selectedId: number;

  readonlyFlag: boolean = true;
  //性别显示
  sexFlag: boolean;
  //显示女
  femaleFlag: boolean;
  //显示男
  maleFlag: boolean;
  isShow: boolean;
  recruitingStatusList: Array<any>;
  //控制tab可不可点
  clickFlag: boolean;
  educationLevelList: Array<any>;
  //新增增员记录的备注
  notice: any;
  trackStatusId: any;
  //控制弹框
  toastDialog: boolean;
  toastInfo: any;
  recruitTrackInfoList: Array<any>;
  resourceList: Array<any>;
  constructor(
    private activateRoute: ActivatedRoute,
    public lifeCommonService: LifeCommonService,
    private myService: MyService) {
    this.titleList = [
      { id: 1, name: '基本信息' },
      { id: 2, name: '简历' },
      { id: 3, name: '增员跟进' }
    ]
  }

  ngOnInit() {
    this.id = this.activateRoute.snapshot.paramMap.get('id');
    console.log(this.id)
    this.dropOptionsQuery(1);
    this.educationLevelQuery();
    if (Number(this.id) === 0) {
      this.readonlyFlag = false;
      this.sexFlag = true;
      this.maleFlag = true;
      this.femaleFlag = true;
      this.clickFlag = false;
      this.editRecruiting = new RecruitingQuery('', 1, '', '', '', '', '', '', '', null, '', '', '', '', '');
      this.selectTab(1);
    } else {
      this.clickFlag = true;
      this.selectTab(1);
    }
  }

  selectTab(id) {
    if (this.clickFlag == true) {
      this.selectedId = id;
      if (this.selectedId === 3) {
        //跟进列表查询
        this.recruitTrackQuery();
        //招募来源列表
        this.dropOptionsQuery(2);
      }
    } else {
      this.selectedId = 1;
    }
  }

  //改为编辑状态出现男女选项
  editInfo() {
    this.readonlyFlag = false;
    this.sexFlag = true;
    this.maleFlag = true;
    this.femaleFlag = true;
  }

  //选男女
  selectedGender(e) {
    this.editRecruiting.gender = e;
  }

  //查询跟进记录
  recruitTrackQuery() {
    const param = {
      potentialId: 26,
      practitionerId: JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']
    }
    this.myService.recruitTrackQuery(param).subscribe((res) => {
      // console.log(res)
      if (res['success']) {
        this.recruitTrackInfoList = res['data']['recruitTrackInfoList'];
      }
    })
  }


  //跟进状态列表type=2跟进状态type=1招募列表
  dropOptionsQuery(type) {
    if (type === 1) {
      //招募来源列表
      this.myService.dropOptionsQuery({ code: 'team_building_source' }).subscribe((res) => {
        if (res['success']) {
          this.resourceList = res['data']['dropMasterInfoList']['0']['dropOptionsInfoList'];
        }
      })
    }
    if (type === 2) {
      //跟进状态列表
      this.myService.dropOptionsQuery({ code: 'team_biulding_track' }).subscribe((res) => {
        if (res['success']) {
          this.recruitingStatusList = res['data']['dropMasterInfoList']['0']['dropOptionsInfoList'];
        }
      })
    }
  }

  // 教育等级查询
  educationLevelQuery() {
    this.myService.educationLevelQuery().subscribe(res => {
      if (res['success']) {
        this.educationLevelList = res['data']['educationLevelList']
      }
    })
  }

  inputBlur() {
    window.scrollTo(0, 0)
  }

  //新增增员基本信息
  saveInfo() {
    this.editRecruiting = {
      ...this.editRecruiting,
      practitionerId: JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']
    }
    console.log(JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'])
    if (!this.editRecruiting.name) {
      this.toastDialog = true;
      this.toastInfo = {
        status: 1,
        msg: '姓名不能为空！',
        timeout: 3000,
        align: 'center'
      };
      return;
    } else {
      this.editRecruiting.name = this.editRecruiting.name.trim();
      if (!this.lifeCommonService.nameValid(this.editRecruiting.name)) {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: '不要乱输姓名哦！',
          timeout: 3000,
          align: 'center'
        };
        return;
      }

    }
    if (!this.editRecruiting.mobileNo) {
      this.toastDialog = true;
      this.toastInfo = {
        status: 1,
        msg: '手机号不能为空！',
        timeout: 3000,
        align: 'center'
      };
      return;
    } else {
      this.editRecruiting.mobileNo = this.editRecruiting.mobileNo.trim()
      if (!this.lifeCommonService.mobileNoValid(this.editRecruiting.mobileNo)) {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: '输入手机号码错误',
          timeout: 3000,
          align: 'center'
        };
        return;
      }
    }
    console.log(this.editRecruiting)
    this.myService.recruit(this.editRecruiting).subscribe((res) => {
      console.log(res)
      if (res['success']) {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: '添加增员对象成功！',
          timeout: 3000,
          align: 'center'
        };
      } else {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: res['message'],
          timeout: 3000,
          align: 'center'
        };
      }
    })
  }

  //新增增员跟进记录
  addRecruitTrack() {
    const RecruitTrackParam = {
      potentialId: 26,//测试先写死小小仙女
      practitionerId: JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'],
      notice: this.notice,
      trackStatusId: this.trackStatusId
    }
    console.log(this.notice)
    this.myService.addRecruitTrack(RecruitTrackParam).subscribe((res) => {
      console.log(res)
      if (res['success']) {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: '保存成功！',
          timeout: 3000,
          align: 'center'
        };
        this.recruitTrackQuery();
      } else {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: res['message'],
          timeout: 3000,
          align: 'center'
        };
      }
    })
  }
}
