import { Component, OnInit } from '@angular/core';
import { ActivatedRoute,Router } from "@angular/router";

@Component({
  selector: 'ydlife-salary-first-year',
  templateUrl: './salary-first-year.component.html',
  styleUrls: ['./salary-first-year.component.scss']
})
export class SalaryFirstYearComponent implements OnInit {
  status:boolean;
  type:any;
  constructor(private activatedRoute: ActivatedRoute) { }

  ngOnInit() {
    this.type = this.activatedRoute.snapshot.queryParams.type?this.activatedRoute.snapshot.queryParams.type:null;
  }

  goBack(){
    history.go(-1);
  }

  getTitleName(type){
    switch (type){
      case '1':
        return '首年度销售佣金';
      case '2':
        return '续年度销售佣金';
      case '3':
        return '首年度辅导奖金';
      case '4':
        return '续年度辅导奖金';
      case '5':
        return '特别管理奖金';
      case '6':
        return '其他应税加扣款';
      default :
        return '/'

    }
  }
}
