import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from "@angular/router";
import { BusinessQuery } from '../../domain/businessQuery';
import { LifeCommonService } from '../../common/life-common.service';

@Component({
  selector: 'ydlife-recruiting-detail',
  templateUrl: './recruiting-detail.component.html',
  styleUrls: ['./recruiting-detail.component.scss']
})
export class RecruitingDetailComponent implements OnInit {
  //潜在增员的id
  id: string;
  titleList: Array<any>;
  selectedId: number;
  editBusiness: BusinessQuery = new BusinessQuery();
  readonlyFlag: boolean = true;
  //性别显示
  sexFlag: boolean;
  //显示女
  femaleFlag: boolean;
  //显示男
  maleFlag: boolean;
  isShow: boolean;

  constructor(
    private activateRoute: ActivatedRoute,
    public lifeCommonService: LifeCommonService) {
    this.titleList = [
      { id: 1, name: '基本信息' },
      { id: 2, name: '简历' },
      { id: 3, name: '增员跟进' }
    ]
  }

  ngOnInit() {
    this.id = this.activateRoute.snapshot.paramMap.get('id');
    console.log(this.id)
    this.selectTab(1);
  }

  selectTab(id) {
    this.selectedId = id;
  }

  //改为编辑状态出现男女选项
  editInfo() {
    this.readonlyFlag = false;
    this.sexFlag = true;
    this.maleFlag = true;
    this.femaleFlag = true;
  }

  //选男女
  selectedGender(e) {
    this.editBusiness.gender = e;
  }

}
