import { Component, OnInit } from '@angular/core';
import { ActivatedRoute,Router } from "@angular/router";
import { MyService } from '../../my.service';
import { LifeCommonService } from "../../../common/life-common.service";

@Component({
  selector: 'ydlife-personal-statement',
  templateUrl: './personal-statement.component.html',
  styleUrls: ['./personal-statement.component.scss']
})
export class PersonalStatementComponent implements OnInit {
  //判断是个人声明还是合同确认
  type:any;
  hiringBasicInfoId:any;
  constructor(private myService: MyService, 
    private activatedRoute: ActivatedRoute,
    public lifeCommonService: LifeCommonService,
    private router: Router) { }

  ngOnInit() {
    this.type = this.activatedRoute.snapshot.data[0]['type'];
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    console.log(this.type)
  }

  next(){
    if(this.type == 'personal_statement'){
      this.router.navigate(['/contract'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
    }else if(this.type == 'contract'){
      this.router.navigate(['/signature'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
    }
  }
}
