import { Component, OnInit } from '@angular/core';
import { MyService } from '../../my.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";

@Component({
  selector: 'ydlife-personal-photos',
  templateUrl: './personal-photos.component.html',
  styleUrls: ['./personal-photos.component.scss']
})
export class PersonalPhotosComponent implements OnInit {
  hiringBasicInfoId:any;
  constructor(private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService) { }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
   
  }

  next(){
    this.router.navigate(['/employee_id_card'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
  }
}
