import { Component, OnInit } from '@angular/core';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";
import { MyService } from '../../my.service';
@Component({
  selector: 'ydlife-employee-info',
  templateUrl: './employee-info.component.html',
  styleUrls: ['./employee-info.component.scss']
})
export class EmployeeInfoComponent implements OnInit {
  hiringBasicInfoId:any;
  membership:any;
  constructor(private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService) { }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.queryMembershipByHiringBasicInfoId(this.hiringBasicInfoId);
  }

  queryMembershipByHiringBasicInfoId(hiringBasicInfoId){
    this.myService.queryMembershipByHiringBasicInfoId({hiringBasicInfoId:hiringBasicInfoId}).subscribe((res)=>{
      console.log(res)
      this.membership = res['data']['membership'];
    })
  }

  next(){
    this.router.navigate(['/employee_basic_info'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
  }

}
