import { Component, OnInit } from '@angular/core';
import { MyService } from '../../my.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";

@Component({
  selector: 'ydlife-employee-basic-info',
  templateUrl: './employee-basic-info.component.html',
  styleUrls: ['./employee-basic-info.component.scss']
})
export class EmployeeBasicInfoComponent implements OnInit {
  idTypesList:Array<any>;
  hiringBasicInfoId:any;
  constructor(private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService) { }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.erpInitialize();
  }

  erpInitialize(){
    this.myService.erpInitialize().subscribe((res)=>{
      if(res['success']){
        this.idTypesList = res['data']['idTypes'];
      }
    })
  }

  next(){
    this.router.navigate(['/work_experience'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
  }
}
