import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from "@angular/router";
import { MyService } from "../my.service";
@Component({
  selector: 'ydlife-sales-rank',
  templateUrl: './sales-rank.component.html',
  styleUrls: ['./sales-rank.component.scss']
})
export class SalesRankComponent implements OnInit {
  time: any;
  performanceList: Array<any>;
  typelist: Array<any>;
  searchList: Array<any>;
  timeType: any;
  searchType: any;
  isOnlineType: any;
  rankList: Array<any>;
  practitionerInfo: any;
  practitionerBasicInfo: any;
  constructor(private activatedRoute: ActivatedRoute, private myService: MyService) {
    this.performanceList = [
      { type: 1, name: '本月' },
      { type: 3, name: '季度' },
      { type: 2, name: '本年' }
    ]
    this.typelist = [
      { type: 2, name: '寿险' },
      { type: 1, name: '线上' },
      
    ]
    this.searchList = [
      { type: 1, name: '首年保费' },
      { type: 2, name: '首年佣金' },
      { type: 3, name: '件数' }
    ]
  }

  ngOnInit() {
    this.practitionerBasicInfo = JSON.parse(localStorage.getItem("lifeCustomerInfo"))['practitionerBasicInfo'];
    this.time = this.activatedRoute.snapshot.queryParams.time ? Number(this.activatedRoute.snapshot.queryParams.time) : null;
    //初始化查寿险保费
    this.rank(this.time, 2, 1)
  }

  /**
    * time  1-month,2-year,3-季度
    * type 1-fyc,2-fyp 3-件数
    * platform //1-online,2-offline
    */
  rank(time, platform, type) {
    this.timeType = time;
    this.isOnlineType = platform;
    this.searchType = type;
    const param = {
      mobileNo: JSON.parse(localStorage.getItem('lifeCustomerInfo'))['mobileNo'],
      time: time,
      platform: platform,
      type: type
    }
    this.myService.rank(param).subscribe((res) => {
      if (res['success']) {
        this.rankList = res['data']['rank'];
        this.practitionerInfo = res['data']['practitionerInfo'];
      } else {
        this.rankList = [];
        this.practitionerInfo = {};
      }
    })
  }
}
