import {Component, EventEmitter, Input, OnInit, Output} from '@angular/core';

@Component({
  selector: 'ydlife-alert',
  templateUrl: './alert.component.html',
  styleUrls: ['./alert.component.scss']
})
export class AlertComponent implements OnInit {

  @Input() dialogInfo: any;
  @Output() popInfo = new EventEmitter();

  constructor() {
    this.dialogInfo = {
      title: null,
      content: {value: '弹窗内容', align: 'center'},
      footer: [{value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary'}],
    };
  }

  ngOnInit() {
  }

  sendInfo() {
    this.popInfo.emit();
  }
}
