import {Component, OnInit, ElementRef, ViewChild} from '@angular/core';
import {MyService} from '../../my/my.service';
import {LifeCommonService} from '../../common/life-common.service';
import {Subscription} from "rxjs/index";
import {OnDestroy} from "@angular/core";
declare const wx: any;

@Component({
  selector: 'ydlife-article-detail',
  templateUrl: './article-detail.component.html',
  styleUrls: ['./article-detail.component.scss']
})
export class ArticleDetailComponent implements OnInit, OnDestroy {
  @ViewChild('payForm') payForm: ElementRef;
  articleInfo: any;
  lifeCustomerInfo: any;
  paymentForm: any;
  customerId: number;
  agentInfo: any;
  shareAbled: boolean = false;
  subscription: Subscription;

  constructor(private myService: MyService, public lifeCommonService: LifeCommonService) {
    this.subscription = lifeCommonService.shareStatus$.subscribe(status => {
      this.shareAbled = !(status == '0');
    });
  }

  ngOnInit() {
    this.articleInfo = JSON.parse(sessionStorage.getItem('articleInfo'));
    this.lifeCustomerInfo = JSON.parse(localStorage.getItem('lifeCustomerInfo')) ? JSON.parse(localStorage.getItem('lifeCustomerInfo')) : null;
    if (this.lifeCustomerInfo) {
      this.customerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['customerId']
    } else {
      this.customerId = null;
    }
    this.agentInfo = {
      headImagePath: this.lifeCustomerInfo.practitionerBasicInfo.headImagePath,
      agentName: this.lifeCustomerInfo.practitionerBasicInfo.name,
      insurerBranchName: this.lifeCustomerInfo.practitionerBasicInfo.insurerBranchName,
      qrCodePath: this.lifeCustomerInfo.practitionerBasicInfo.qrCodePath,
      mobileNo: this.lifeCustomerInfo.mobileNo
    };
    this.lifeCommonService.wxShare(this.articleInfo.title, `来自银盾经纪人${this.agentInfo.agentName}的分享`, `${window.location.href}`, this.articleInfo.coverUrl);
    if (this.lifeCommonService.checkDeviceType() == '3' && !this.customerId) {
      this.getWxUserInfo();
    }
  }

  ngOnDestroy() {
    this.subscription.unsubscribe();
  }

  // 从后台获取到获取微信code的URL
  getWxUserInfo() {
    this.myService.getWxUserInfo().subscribe(res => {
      if (res['success']) {
        this.paymentForm = res['data'].paymentForm;
        this.getOrPost(this.paymentForm.action, this.paymentForm.param, this.paymentForm.charset, this.paymentForm.actionType);
      }
    })
  }

  // 点击分享
  share() {
    this.shareAbled = !this.shareAbled;
    this.lifeCommonService.wxShare(this.articleInfo.title, `来自银盾经纪人${this.agentInfo.agentName}的分享`, `${window.location.href}`, this.articleInfo.coverUrl);
    setTimeout(() => {
      this.shareAbled = false;
    }, 6000);
  }


  // 判断是get请求还是post请求进行支付请求
  getOrPost(action, params, charset, actionType) {
    let url = '';
    let paramHTML = '';
    let hiddenContent = '';
    if (actionType.toLowerCase() === 'get') {
      url = action;
      if (params) {
        for (let i = 0; i < params.length; i++) {
          url += '&' + params[i].name + '=' + params[i].value;
        }
      }
      window.location.href = url;
    } else if (actionType.toLowerCase() === 'post') {
      if (params) {
        for (let i = 0; i < params.length; i++) {
          paramHTML += '<input type="text" value="' + params[i].value + '" name="' + params[i].name + '" hidden>'
        }
      }
      hiddenContent +=
        '<form action="' + action + '"method="post" accept-charset="' + charset + '" onsubmit="document.charset=\'' + charset + '\';">'
        + paramHTML
        + '<button type="submit" id="submit" hidden></button>'
        + '</form>';
      this.payForm.nativeElement.innerHTML = hiddenContent;
      document.getElementById('submit').click();
    }
  }
}
