import {NgModule} from '@angular/core';
import {Routes, RouterModule} from '@angular/router';
import {MyCenterHomeComponent} from './my-center-home/my-center-home.component';
import {AuthGuard} from '../auth/auth.guard';
import {MkMaterialComponent} from './mk-material/mk-material.component';
import {MkMaterialDetailComponent} from './mk-material-detail/mk-material-detail.component';
import {FileUploadComponent} from './file-upload/file-upload.component';
import {ImportantAnnouncementComponent} from './important-announcement/important-announcement.component';

const myRoutes: Routes = [
  {path: '', component: MyCenterHomeComponent, canActivate: [AuthGuard]},
  {path: 'material', component: MkMaterialComponent, canActivate: [AuthGuard]},
  {path: 'material/:itemId', component: MkMaterialDetailComponent, canActivate: [AuthGuard]},
  {path: 'fileUpload', component: FileUploadComponent, canActivate: [AuthGuard], data: [{type: 'fileUpload'}]},
  {path: 'training', component: FileUploadComponent, canActivate: [AuthGuard], data: [{type: 'training'}]},
  {path: 'importantAnnouncement', component: ImportantAnnouncementComponent, canActivate: [AuthGuard]},
];

@NgModule({
  imports: [RouterModule.forChild(myRoutes)],
  exports: [RouterModule]
})
export class MyRoutingModule {
}
