import { Component, OnInit } from '@angular/core';
import { Router } from "@angular/router";
import { MyService } from "../my.service";
import { ActivatedRoute } from "@angular/router";
@Component({
  selector: 'ydlife-mk-material',
  templateUrl: './mk-material.component.html',
  styleUrls: ['./mk-material.component.scss']
})
export class MkMaterialComponent implements OnInit {
  posterInfos: Array<any>;
  categoryList: Array<any>;
  selectedCategoryId: number;
  recruit: any;
  constructor(private activatedRoute: ActivatedRoute, private router: Router, private myService: MyService) {
  }

  ngOnInit() {
    this.recruit = this.activatedRoute.snapshot.queryParams.recruit ? this.activatedRoute.snapshot.queryParams.recruit : null;
    this.dropOptionsQuery();
  }

  posterQuery() {
    const param = {
      practitionerId: JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'],
      mdDropOptionId: this.selectedCategoryId,
      paginationInfo: { noLimitFlag: 'CONFIRM' }
    }
    this.myService.posterQuery(param).subscribe(res => {
      if (res['success']) {
        this.posterInfos = res['data']['posterInfos'];
      }
    });
  }

  //海报分类
  dropOptionsQuery() {
    this.myService.dropOptionsQuery({ code: 'yd_productbill_file_type' }).subscribe(res => {
      if (res['success']) {
        this.categoryList = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'];
        if (this.categoryList.length > 0) {
          if (this.recruit == 'recruit') {
            this.selectedCategoryId = 78;
            this.categoryList = this.categoryList.filter((item) => {
              return item.id == 78;
            })
          } else {
            this.selectedCategoryId = this.categoryList[0].id;
          }
          this.posterQuery();
        }
      } else {
        this.categoryList = [];
      }
    })
  }

  switchCategory(e) {
    this.selectedCategoryId = e;
    this.posterQuery();
  }
}
