import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import {Router,ActivatedRoute} from "@angular/router";

@Component({
  selector: 'ydlife-approval-list',
  templateUrl: './approval-list.component.html',
  styleUrls: ['./approval-list.component.scss']
})
export class ApprovalListComponent implements OnInit {
  titleList:Array<any>;
  selectedId:number = 0;
  practitionerId:any;
  approvarList:Array<any>;
  constructor(private myService:MyService,private router:Router) { }

  ngOnInit() {
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.titleList = [
      { id: 0, name: '待审批' },
      { id: 1, name: '通过' },
      { id: 2, name: '拒绝' }
    ]
    this.listQuery();
  }

  selectTab(id) {
    this.selectedId = id;
  }

  listQuery(){
    this.myService.listQuery({practitionerId:this.practitionerId}).subscribe((res)=>{
      console.log(res)
      if(res['success']){
        this.approvarList = res['data']['hiringListInfoList'];
      }
    })
  }

  jumpToDetail(item,type?:any){
    if(type){
      sessionStorage.setItem('viewApprovalInfo','1')
    }else{
      sessionStorage.setItem('viewApprovalInfo','0')
    }
    if(this.selectedId == 0 || type=='view'){
      this.router.navigate([`/employee_basic_info`],{queryParams:{hiringBasicInfoId:item.hiringBasicInfoId,approvalIdentity:item.approvalIdentity}})
    }else{
      this.router.navigate([`/approval_result_list`],{queryParams:{hiringBasicInfoId:item.hiringBasicInfoId,approvalIdentity:item.approvalIdentity}})

    }
  }

}
