import { Component, OnInit } from '@angular/core';
import { MyService } from '../../my.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";
import { ExperienceQuery } from '../../../domain/experienceQuery';

@Component({
  selector: 'ydlife-work-experience',
  templateUrl: './work-experience.component.html',
  styleUrls: ['./work-experience.component.scss']
})
export class WorkExperienceComponent implements OnInit {
  hiringBasicInfoId:any;
  addExperience:ExperienceQuery = new ExperienceQuery(null,null,null,null);
  //工作经历列表
  experienceList:Array<any>;
  minDate:any = new Date('1900-01-01');
  showworkingStart:any=null;
  showworkingEnd:any = null;
  maxDate:any = new Date();
  //控制弹框
  toastDialog: boolean;
  toastInfo: any;
  isNeedAlert: boolean;
  dialogInfo: any;
  approvalIdentity:any;
  constructor(private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService) { 
      this.experienceList = [];
    }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.approvalIdentity = this.activatedRoute.snapshot.queryParams.approvalIdentity?this.activatedRoute.snapshot.queryParams.approvalIdentity:null;
    this.addExperience = new ExperienceQuery(null, null, null,null);
    this.queryWholeInfo(this.hiringBasicInfoId)
  }

  next(){
    if(this.addExperience.workingCompany || this.addExperience.position || this.addExperience.workingStart || this.addExperience.workingEnd){
      this.experienceList.push(this.addExperience)
    }else{
      this.experienceList = [];
    }
    const experienceParam = {
      workingExperienceList:this.experienceList,
      hiringBasicInfoId:this.hiringBasicInfoId
    }
    this.myService.saveWorkingExperience(experienceParam).subscribe((res)=>{
      if(res['success']){
        this.router.navigate(['/personal_photos'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
      }else{
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: res['message'],
          timeout: 3000,
          align: 'center'
        };
      }
    })
  }

  addExperienceList() {
    //先push进去list在清空
    if(this.addExperience.workingCompany || this.addExperience.position || this.addExperience.workingStart || this.addExperience.workingEnd){
      this.experienceList.push(this.addExperience)
      this.showworkingStart=null;
      this.showworkingEnd = null;
      this.addExperience = new ExperienceQuery(null, null, null,null);
    }
  }

  currentDateFormat(date, format: string = 'yyyy-mm-dd HH:MM'): any {
    if(date){
      const pad = (n: number): string => (n < 10 ? `0${n}` : n.toString());
      return format
        .replace('yyyy', date.getFullYear())
        .replace('mm', pad(date.getMonth() + 1))
        .replace('dd', pad(date.getDate()))
        .replace('HH', pad(date.getHours()))
        .replace('MM', pad(date.getMinutes()))
        .replace('ss', pad(date.getSeconds()));
    }
    
  }

  onOk(result: Date,type) {
    if(type=='start'){
      this.addExperience.workingStart = this.currentDateFormat(result, 'yyyy-mm-dd');
      this.showworkingStart = result;
    }
    if(type=='end'){
      this.addExperience.workingEnd = this.currentDateFormat(result, 'yyyy-mm-dd');
      this.showworkingEnd =result;
    }
  }

   // 打开弹窗
   openPopInfo(message) {
    this.isNeedAlert = true;
    this.dialogInfo = {
      title: null,
      content: { value: message, align: 'center' },
      footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
    };
  }

  // 关闭弹窗
  getPopInfo() {
    this.isNeedAlert = false;
  }

  queryWholeInfo(hiringBasicInfoId){
    this.myService.queryWholeInfo({hiringBasicInfoId:hiringBasicInfoId}).subscribe((res)=>{
     if(res['success']){
      const  experienceList = res['data']['hiringWorkingExperienceList'];
      for(let i=0;i<experienceList.length;i++){
        this.experienceList.push({workingCompany:experienceList[i].workingCompany,
          position:experienceList[i].position,
          workingStart:experienceList[i].workingStart,
          workingEnd:experienceList[i].workingEnd
        })
      }
      

      }
    })
  }

  viewNext(){
    this.router.navigate(['/personal_photos'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId,approvalIdentity:this.approvalIdentity} });
  }

  goBack(){
    history.go(-1)
  }
}
