import { Component, OnInit,ViewChild,ElementRef  } from '@angular/core';
import { MyService } from '../../my.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";
import {SignaturePad} from 'angular2-signaturepad';
import EleSign from "elesigncode";
import * as $ from 'jquery';
@Component({
  selector: 'ydlife-signature',
  templateUrl: './signature.component.html',
  styleUrls: ['./signature.component.scss']
})
export class SignatureComponent implements OnInit {
  hiringBasicInfoId:any;
  signatureImage:string;
  signaturePadOptions:any;
  imgStr:any;
  isNeedAlert: boolean;
  dialogInfo: any;
  isSignatureShow:boolean;
  approvalIdentity:any;
  viewApprovalInfo:any;
  @ViewChild(SignaturePad) signaturePad : SignaturePad;
  constructor(private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService) { 
      
       
      
    }

  ngOnInit() {
    this.approvalIdentity = this.activatedRoute.snapshot.queryParams.approvalIdentity?this.activatedRoute.snapshot.queryParams.approvalIdentity:null;
    this.signaturePadOptions = {
      minWidth: 2,
      maxWidth: 5,
      dotSize: 1.5,
      penColor: "#333",
      /* INVERSE BECAUSE IT IS SHOW ONLY IN LANDSCAPE */
      canvasWidth: document.body.clientWidth-26,
      canvasHeight: 400,
      // backgroundColor:"rgb(248 248 248)"
    }
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.queryWholeInfo(this.hiringBasicInfoId)
    this.viewApprovalInfo = sessionStorage.getItem('viewApprovalInfo');
  }

  next(){
    if(this.isSignatureShow == false){
      this.saveDigitalSignatures();
    }else{
      this.router.navigate(['/employee_submit']);
    }
  }

  drawComplete() {
    this.imgStr = this.signaturePad.toDataURL();
  }

  drawStart() {
    // console.log('begin drawing');
  }

  saveDigitalSignatures(){
    if (this.signaturePad.isEmpty()) {
      this.openPopInfo('您还没有签名！');
      return;
    }
    const param = {
      hiringBasicInfoId:this.hiringBasicInfoId,
      imgStr:this.imgStr
    }
    this.myService.saveDigitalSignatures(param).subscribe((res)=>{
      if(res['success']){
        this.queryWholeInfo(this.hiringBasicInfoId);
        this.router.navigate(['/employee_submit']);
      }else{
        this.openPopInfo(res['message']);
      }
    })
  }

  queryWholeInfo(hiringBasicInfoId){
    this.myService.queryWholeInfo({hiringBasicInfoId:hiringBasicInfoId}).subscribe((res)=>{
      if(res['success']){
        if(res['data']['hiringBasicInfo']['personalSignOssPath']){
          this.imgStr = res['data']['hiringBasicInfo']['personalSignOssPath'];
          this.isSignatureShow = true;
        }else{
          this.isSignatureShow = false;
        }
      }else{
        this.isSignatureShow = false;
      }
    })
  }

  revokeSignature(){
    var data = this.signaturePad.toData();
    if (data) {
      data.pop(); // remove the last dot or line
      this.signaturePad.fromData(data);
    }
    this.drawComplete();
  }

  // 打开弹窗
  openPopInfo(message) {
    this.isNeedAlert = true;
    this.dialogInfo = {
      title: null,
      content: { value: message, align: 'center' },
      footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
    };
  }

  // 关闭弹窗
  getPopInfo() {
    this.isNeedAlert = false;
  }

  clearSignature(){
    if(this.isSignatureShow == true){
      this.isSignatureShow = false;
      this.signaturePad.clear();
    }
  }

  viewNext(){
    this.router.navigate(['/approval_comments'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId,approvalIdentity:this.approvalIdentity} });
  }

  goBack(){
    history.go(-1)
  }
}
